/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.ClusterInvokeAcceptor;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClusterInvokeAcceptorUtil {
    private static final Map<String, ClusterInvokeAcceptor> _clusterInvokeAcceptors = new ConcurrentHashMap<String, ClusterInvokeAcceptor>();
    private static final ServiceTracker<ClusterInvokeAcceptor, ClusterInvokeAcceptor> _serviceTracker;

    public static ClusterInvokeAcceptor getClusterInvokeAcceptor(String clusterInvokeAcceptorName) {
        return _clusterInvokeAcceptors.get(clusterInvokeAcceptorName);
    }

    private ClusterInvokeAcceptorUtil() {
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(ClusterInvokeAcceptor.class, new ClusterInvokeAcceptorServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class ClusterInvokeAcceptorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ClusterInvokeAcceptor, ClusterInvokeAcceptor> {
        private ClusterInvokeAcceptorServiceTrackerCustomizer() {
        }

        @Override
        public ClusterInvokeAcceptor addingService(ServiceReference<ClusterInvokeAcceptor> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            ClusterInvokeAcceptor clusterInvokeAcceptor = registry.getService(serviceReference);
            Class<?> clazz = clusterInvokeAcceptor.getClass();
            _clusterInvokeAcceptors.put(clazz.getName(), clusterInvokeAcceptor);
            return clusterInvokeAcceptor;
        }

        @Override
        public void modifiedService(ServiceReference<ClusterInvokeAcceptor> serviceReference, ClusterInvokeAcceptor clusterInvokeAcceptor) {
            Class<?> clazz = clusterInvokeAcceptor.getClass();
            _clusterInvokeAcceptors.put(clazz.getName(), clusterInvokeAcceptor);
        }

        @Override
        public void removedService(ServiceReference<ClusterInvokeAcceptor> serviceReference, ClusterInvokeAcceptor clusterInvokeAcceptor) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            Class<?> clazz = clusterInvokeAcceptor.getClass();
            _clusterInvokeAcceptors.remove(clazz.getName());
        }
    }
}

