/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.atom;

import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AtomCollectionAdapterRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(AtomCollectionAdapterRegistryUtil.class);
    private static final AtomCollectionAdapterRegistryUtil _instance = new AtomCollectionAdapterRegistryUtil();
    private final Map<String, AtomCollectionAdapter<?>> _atomCollectionAdapters = new ConcurrentHashMap();
    private final ServiceTracker<AtomCollectionAdapter<?>, AtomCollectionAdapter<?>> _serviceTracker;

    public static AtomCollectionAdapter<?> getAtomCollectionAdapter(String collectionName) {
        return _instance._getAtomCollectionAdapter(collectionName);
    }

    public static List<AtomCollectionAdapter<?>> getAtomCollectionAdapters() {
        return _instance._getAtomCollectionAdapters();
    }

    private AtomCollectionAdapterRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(AtomCollectionAdapter.class, new AtomCollectionAdapterServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private AtomCollectionAdapter<?> _getAtomCollectionAdapter(String collectionName) {
        return this._atomCollectionAdapters.get(collectionName);
    }

    private List<AtomCollectionAdapter<?>> _getAtomCollectionAdapters() {
        return ListUtil.fromMapValues(this._atomCollectionAdapters);
    }

    private class AtomCollectionAdapterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AtomCollectionAdapter<?>, AtomCollectionAdapter<?>> {
        private AtomCollectionAdapterServiceTrackerCustomizer() {
        }

        @Override
        public AtomCollectionAdapter<?> addingService(ServiceReference<AtomCollectionAdapter<?>> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            AtomCollectionAdapter<?> atomCollectionAdapter = registry.getService(serviceReference);
            if (AtomCollectionAdapterRegistryUtil.this._atomCollectionAdapters.containsKey(atomCollectionAdapter.getCollectionName())) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Duplicate collection name " + atomCollectionAdapter.getCollectionName());
                }
                return null;
            }
            AtomCollectionAdapterRegistryUtil.this._atomCollectionAdapters.put(atomCollectionAdapter.getCollectionName(), atomCollectionAdapter);
            return atomCollectionAdapter;
        }

        @Override
        public void modifiedService(ServiceReference<AtomCollectionAdapter<?>> serviceReference, AtomCollectionAdapter<?> atomCollectionAdapter) {
        }

        @Override
        public void removedService(ServiceReference<AtomCollectionAdapter<?>> serviceReference, AtomCollectionAdapter<?> atomCollectionAdapter) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            AtomCollectionAdapterRegistryUtil.this._atomCollectionAdapters.remove(atomCollectionAdapter.getCollectionName());
        }
    }
}

