/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.action.JSONServiceAction;
import com.liferay.portal.jsonwebservice.action.JSONWebServiceDiscoverAction;
import com.liferay.portal.jsonwebservice.action.JSONWebServiceInvokerAction;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.jsonwebservice.NoSuchJSONWebServiceException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSONWebServiceServiceAction
extends JSONServiceAction {
    private static final String _REROUTE_PATH = "/jsonws";
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceServiceAction.class);

    @Override
    public String getJSON(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UploadException uploadException = (UploadException)httpServletRequest.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            return JSONFactoryUtil.serializeThrowable(uploadException);
        }
        try {
            JSONWebServiceAction jsonWebServiceAction = this.getJSONWebServiceAction(httpServletRequest);
            Object returnObj = jsonWebServiceAction.invoke();
            if (returnObj != null) {
                return this.getReturnValue(returnObj);
            }
            return JSONFactoryUtil.getNullJSON();
        }
        catch (Throwable throwable) {
            int status = 0;
            if (throwable instanceof InvocationTargetException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof NoSuchJSONWebServiceException) {
                status = 404;
            } else {
                if (throwable instanceof NoSuchModelException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug(this.getThrowableMessage(throwable), throwable);
                    }
                    httpServletResponse.setStatus(404);
                    return JSONFactoryUtil.serializeThrowable(throwable);
                }
                if (throwable instanceof PrincipalException || throwable instanceof SecurityException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug(this.getThrowableMessage(throwable), throwable);
                    }
                    httpServletResponse.setStatus(403);
                    return JSONFactoryUtil.serializeThrowable(throwable);
                }
                status = 500;
            }
            if (_log.isDebugEnabled()) {
                _log.debug(this.getThrowableMessage(throwable), throwable);
            } else {
                _log.error(this.getThrowableMessage(throwable));
            }
            httpServletResponse.setStatus(status);
            return JSONFactoryUtil.serializeThrowable(throwable);
        }
    }

    @Override
    protected String getCSRFOrigin(HttpServletRequest httpServletRequest) {
        String uri = httpServletRequest.getRequestURI();
        int x = uri.indexOf("jsonws/");
        if (x < 0) {
            return ClassUtil.getClassName(this);
        }
        String path = uri.substring(x + 7);
        String[] pathArray = StringUtil.split(path, '/');
        if (pathArray.length < 2) {
            return ClassUtil.getClassName(this);
        }
        StringBundler sb = new StringBundler(6);
        sb.append(ClassUtil.getClassName(this));
        sb.append(":");
        sb.append("/");
        String serviceClassName = pathArray[0];
        sb.append(serviceClassName);
        sb.append("/");
        String serviceMethodName = pathArray[1];
        sb.append(serviceMethodName);
        return sb.toString();
    }

    protected JSONWebServiceAction getJSONWebServiceAction(HttpServletRequest httpServletRequest) throws NoSuchJSONWebServiceException {
        String path = GetterUtil.getString(httpServletRequest.getPathInfo());
        if (path.equals("/invoke")) {
            return new JSONWebServiceInvokerAction(httpServletRequest);
        }
        if (PropsValues.JSONWS_WEB_SERVICE_API_DISCOVERABLE && httpServletRequest.getParameter("discover") != null) {
            return new JSONWebServiceDiscoverAction(httpServletRequest);
        }
        return JSONWebServiceActionsManagerUtil.getJSONWebServiceAction(httpServletRequest);
    }

    @Override
    protected String getReroutePath() {
        return _REROUTE_PATH;
    }

    protected String getThrowableMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (Validator.isNotNull(message)) {
            return message;
        }
        return throwable.toString();
    }
}

