/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.MethodParametersResolverUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.Objects;

public class JSONWebServiceActionConfig
implements Comparable<JSONWebServiceActionConfig>,
JSONWebServiceActionMapping {
    private final Class<?> _actionClass;
    private final Method _actionMethod;
    private final Object _actionObject;
    private final String _contextName;
    private final String _contextPath;
    private final boolean _deprecated;
    private final String _method;
    private final String _path;
    private final Method _realActionMethod;
    private final String _signature;

    public JSONWebServiceActionConfig(String contextName, String contextPath, Class<?> actionClass, Method actionMethod, String path, String method) {
        this(contextName, contextPath, null, actionClass, actionMethod, path, method);
    }

    public JSONWebServiceActionConfig(String contextName, String contextPath, Object actionObject, Class<?> actionClass, Method actionMethod, String path, String method) {
        this._contextName = GetterUtil.getString(contextName);
        this._contextPath = GetterUtil.getString(contextPath);
        this._actionObject = actionObject;
        this._actionClass = actionClass;
        Method newActionMethod = actionMethod;
        if (actionObject != null) {
            try {
                Class<?> actionObjectClass = actionObject.getClass();
                newActionMethod = actionObjectClass.getMethod(actionMethod.getName(), actionMethod.getParameterTypes());
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException(nsme);
            }
        }
        this._actionMethod = newActionMethod;
        if (Validator.isNotNull(this._contextName)) {
            StringBundler sb = new StringBundler(4);
            sb.append("/");
            sb.append(this._contextName);
            sb.append(".");
            sb.append(path.substring(1));
            path = sb.toString();
        }
        this._path = path;
        this._method = method;
        Deprecated deprecated = actionMethod.getAnnotation(Deprecated.class);
        this._deprecated = deprecated != null;
        Method realActionMethod = null;
        try {
            realActionMethod = this._actionClass.getDeclaredMethod(actionMethod.getName(), actionMethod.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this._realActionMethod = realActionMethod;
        Class<?>[] parameterTypes = this._actionMethod.getParameterTypes();
        StringBundler sb = new StringBundler(parameterTypes.length * 2 + 3);
        sb.append(this._path);
        sb.append("-");
        sb.append(parameterTypes.length);
        for (Class<?> parameterType : parameterTypes) {
            sb.append("-");
            sb.append(parameterType.getName());
        }
        this._signature = sb.toString();
    }

    @Override
    public int compareTo(JSONWebServiceActionConfig jsonWebServiceActionConfig) {
        return this._signature.compareTo(jsonWebServiceActionConfig._signature);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JSONWebServiceActionConfig)) {
            return false;
        }
        JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)object;
        return Objects.equals(this._signature, jsonWebServiceActionConfig._signature);
    }

    @Override
    public Class<?> getActionClass() {
        return this._actionClass;
    }

    @Override
    public Method getActionMethod() {
        return this._actionMethod;
    }

    @Override
    public Object getActionObject() {
        return this._actionObject;
    }

    @Override
    public String getContextName() {
        return this._contextName;
    }

    @Override
    public String getContextPath() {
        return this._contextPath;
    }

    @Override
    public String getMethod() {
        return this._method;
    }

    @Override
    public MethodParameter[] getMethodParameters() {
        if (this._realActionMethod == null) {
            return new MethodParameter[0];
        }
        return MethodParametersResolverUtil.resolveMethodParameters(this._realActionMethod);
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public Method getRealActionMethod() {
        return this._realActionMethod;
    }

    @Override
    public String getSignature() {
        return this._signature;
    }

    public int hashCode() {
        return this._signature.hashCode();
    }

    @Override
    public boolean isDeprecated() {
        return this._deprecated;
    }

    public String toString() {
        StringBundler sb = new StringBundler(19);
        sb.append("{actionClass=");
        sb.append(this._actionClass);
        sb.append(", actionMethod=");
        sb.append(this._actionMethod);
        sb.append(", contextName=");
        sb.append(this._contextName);
        sb.append(", contextPath=");
        sb.append(this._contextPath);
        sb.append(", deprecated=");
        sb.append(this._deprecated);
        sb.append(", method=");
        sb.append(this._method);
        sb.append(", path=");
        sb.append(this._path);
        sb.append(", realActionMethod=");
        sb.append(this._realActionMethod);
        sb.append(", signature=");
        sb.append(this._signature);
        sb.append("}");
        return sb.toString();
    }
}

