/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.jabsorb.serializer;

import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONObject;

public class LocaleSerializer
extends AbstractSerializer {
    private static final Class<?>[] _JSON_CLASSES = new Class[]{JSONObject.class};
    private static final Class<?>[] _SERIALIZABLE_CLASSES = new Class[]{Locale.class};

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return Locale.class.isAssignableFrom(clazz) && (jsonClazz == null || jsonClazz == JSONObject.class);
    }

    public Class<?>[] getJSONClasses() {
        return _JSON_CLASSES;
    }

    public Class<?>[] getSerializableClasses() {
        return _SERIALIZABLE_CLASSES;
    }

    public Object marshall(SerializerState serializerState, Object parentObject, Object object) throws MarshallException {
        JSONObject jsonObject = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            try {
                Class<?> javaClass = object.getClass();
                jsonObject.put("javaClass", (Object)javaClass.getName());
            }
            catch (Exception e) {
                throw new MarshallException("Unable to put javaClass", (Throwable)e);
            }
        }
        JSONObject localeJSONObject = new JSONObject();
        try {
            jsonObject.put("locale", (Object)localeJSONObject);
            serializerState.push(object, (Object)localeJSONObject, (Object)"locale");
        }
        catch (Exception e) {
            throw new MarshallException("Unable to put locale", (Throwable)e);
        }
        try {
            Locale locale = (Locale)object;
            localeJSONObject.put("country", (Object)locale.getCountry());
            localeJSONObject.put("language", (Object)locale.getLanguage());
            localeJSONObject.put("variant", (Object)locale.getVariant());
        }
        catch (Exception e) {
            throw new MarshallException("Unable to put country, language, and variant", (Throwable)e);
        }
        finally {
            serializerState.pop();
        }
        return jsonObject;
    }

    public ObjectMatch tryUnmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
        JSONObject localeJSONObject = this.getLocaleJSONObject(object);
        ObjectMatch objectMatch = ObjectMatch.ROUGHLY_SIMILAR;
        if (localeJSONObject.has("language")) {
            objectMatch = ObjectMatch.OKAY;
        }
        serializerState.setSerialized(object, (Object)objectMatch);
        return objectMatch;
    }

    public Object unmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
        JSONObject localeJSONObject = this.getLocaleJSONObject(object);
        String country = null;
        try {
            country = localeJSONObject.getString("country");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String language = null;
        try {
            language = localeJSONObject.getString("language");
        }
        catch (Exception e) {
            throw new UnmarshallException("language is undefined", (Throwable)e);
        }
        String variant = null;
        try {
            variant = localeJSONObject.getString("variant");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Locale locale = null;
        locale = Validator.isNotNull(country) && Validator.isNotNull(language) && Validator.isNotNull(variant) ? new Locale(language, country, variant) : (Validator.isNotNull(country) && Validator.isNotNull(language) ? new Locale(language, country) : new Locale(language));
        serializerState.setSerialized(object, (Object)locale);
        return locale;
    }

    protected JSONObject getLocaleJSONObject(Object object) throws UnmarshallException {
        JSONObject jsonObject = (JSONObject)object;
        String javaClassName = null;
        try {
            javaClassName = jsonObject.getString("javaClass");
        }
        catch (Exception e) {
            throw new UnmarshallException("Unable to get javaClass", (Throwable)e);
        }
        if (javaClassName == null) {
            throw new UnmarshallException("javaClass is undefined");
        }
        try {
            Class.forName(javaClassName);
        }
        catch (Exception e) {
            throw new UnmarshallException("Unable to load javaClass " + javaClassName, (Throwable)e);
        }
        JSONObject localeJSONObject = null;
        try {
            localeJSONObject = jsonObject.getJSONObject("locale");
        }
        catch (Exception e) {
            throw new UnmarshallException("Unable to get locale", (Throwable)e);
        }
        if (localeJSONObject == null) {
            throw new UnmarshallException("locale is undefined");
        }
        return localeJSONObject;
    }
}

