/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.jabsorb.serializer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class LiferayJSONDeserializationWhitelist {
    private static final Log _log = LogFactoryUtil.getLog(LiferayJSONDeserializationWhitelist.class);
    private final Map<String, AtomicInteger> _registeredClassNames = new ConcurrentHashMap<String, AtomicInteger>();

    public LiferayJSONDeserializationWhitelist() {
        for (String className : PropsUtil.getArray("json.deserialization.whitelist.class.names")) {
            this._registeredClassNames.put(className, new AtomicInteger(1));
        }
    }

    public boolean isWhitelisted(String className) {
        if (this._registeredClassNames.containsKey(className)) {
            return true;
        }
        if (_log.isWarnEnabled()) {
            _log.warn(StringBundler.concat("Unable to deserialize ", className, " due to security restrictions"));
        }
        return false;
    }

    public Closeable register(final String ... classNames) {
        for (String className : classNames) {
            this._registeredClassNames.compute(className, (keyClassName, counter) -> {
                if (counter == null) {
                    return new AtomicInteger(1);
                }
                counter.incrementAndGet();
                return counter;
            });
        }
        return new Closeable(){
            private final AtomicBoolean _closed = new AtomicBoolean();

            @Override
            public void close() {
                if (!this._closed.compareAndSet(false, true)) {
                    return;
                }
                for (String className : classNames) {
                    LiferayJSONDeserializationWhitelist.this._registeredClassNames.compute(className, (keyClassName, counter) -> {
                        if (counter.decrementAndGet() == 0) {
                            return null;
                        }
                        return counter;
                    });
                }
            }
        };
    }
}

