/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json;

import com.liferay.portal.json.JoddJsonTransformer;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.json.JSONTransformer;
import com.liferay.portal.kernel.util.JavaDetector;
import jodd.json.JoddJson;
import jodd.json.JsonContext;
import jodd.json.JsonSerializer;
import jodd.json.TypeJsonSerializer;
import jodd.util.SystemUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONSerializerImpl
implements JSONSerializer {
    private final JsonSerializer _jsonSerializer;

    public JSONSerializerImpl() {
        if (JavaDetector.isIBM()) {
            SystemUtil.disableUnsafeUsage();
        }
        this._jsonSerializer = new JsonSerializer();
    }

    @Override
    public JSONSerializerImpl exclude(String ... fields) {
        this._jsonSerializer.exclude(fields);
        return this;
    }

    @Override
    public JSONSerializerImpl include(String ... fields) {
        this._jsonSerializer.include(fields);
        return this;
    }

    @Override
    public String serialize(Object target) {
        return this._jsonSerializer.serialize(target);
    }

    @Override
    public String serializeDeep(Object target) {
        JsonSerializer jsonSerializer = this._jsonSerializer.deep(true);
        return jsonSerializer.serialize(target);
    }

    @Override
    public JSONSerializerImpl transform(JSONTransformer jsonTransformer, Class<?> type) {
        Object typeJsonSerializer = null;
        typeJsonSerializer = jsonTransformer instanceof TypeJsonSerializer ? (TypeJsonSerializer)jsonTransformer : new JoddJsonTransformer(jsonTransformer);
        this._jsonSerializer.use(type, typeJsonSerializer);
        return this;
    }

    @Override
    public JSONSerializerImpl transform(JSONTransformer jsonTransformer, String field) {
        Object typeJsonSerializer = null;
        typeJsonSerializer = jsonTransformer instanceof TypeJsonSerializer ? (TypeJsonSerializer)jsonTransformer : new JoddJsonTransformer(jsonTransformer);
        this._jsonSerializer.use(field, typeJsonSerializer);
        return this;
    }

    static {
        JoddJson.defaultSerializers.register(JSONArray.class, (TypeJsonSerializer)new JSONArrayTypeJSONSerializer());
        JoddJson.defaultSerializers.register(JSONObject.class, (TypeJsonSerializer)new JSONObjectTypeJSONSerializer());
        JoddJson.defaultSerializers.register(Long.TYPE, (TypeJsonSerializer)new LongToStringTypeJSONSerializer());
        JoddJson.defaultSerializers.register(Long.class, (TypeJsonSerializer)new LongToStringTypeJSONSerializer());
    }

    private static class LongToStringTypeJSONSerializer
    implements TypeJsonSerializer<Long> {
        private LongToStringTypeJSONSerializer() {
        }

        public void serialize(JsonContext jsonContext, Long value) {
            jsonContext.writeString(String.valueOf(value));
        }
    }

    private static class JSONObjectTypeJSONSerializer
    implements TypeJsonSerializer<JSONObject> {
        private JSONObjectTypeJSONSerializer() {
        }

        public void serialize(JsonContext jsonContext, JSONObject jsonObject) {
            jsonContext.write((CharSequence)jsonObject.toString());
        }
    }

    private static class JSONArrayTypeJSONSerializer
    implements TypeJsonSerializer<JSONArray> {
        private JSONArrayTypeJSONSerializer() {
        }

        public void serialize(JsonContext jsonContext, JSONArray jsonArray) {
            jsonContext.write((CharSequence)jsonArray.toString());
        }
    }
}

