/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.events.StartupAction;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.patcher.PatchInconsistencyException;
import com.liferay.portal.kernel.patcher.PatcherUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.InactiveRequestHandler;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.service.impl.LayoutTemplateLocalServiceImpl;
import com.liferay.portal.servlet.EncryptedServletRequest;
import com.liferay.portal.servlet.I18nServlet;
import com.liferay.portal.servlet.filters.absoluteredirects.AbsoluteRedirectsResponse;
import com.liferay.portal.servlet.filters.i18n.I18nFilter;
import com.liferay.portal.setup.SetupWizardSampleDataUtil;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.PortalRequestProcessor;
import com.liferay.portal.struts.StrutsUtil;
import com.liferay.portal.struts.TilesUtil;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.struts.model.ModuleConfig;
import com.liferay.portal.util.ExtRegistry;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import com.liferay.social.kernel.util.SocialConfigurationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MainServlet
extends HttpServlet {
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_DEFAULT = StringUtil.equalsIgnoreCase(PropsValues.HTTP_HEADER_VERSION_VERBOSITY, "off");
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_PARTIAL = StringUtil.equalsIgnoreCase(PropsValues.HTTP_HEADER_VERSION_VERBOSITY, "partial");
    private static final String _LIFERAY_PORTAL_REQUEST_HEADER = "Liferay-Portal";
    private static final Log _log = LogFactoryUtil.getLog(MainServlet.class);
    private static volatile InactiveRequestHandler _inactiveRequestHandler = ServiceProxyFactory.newServiceTrackedInstance(InactiveRequestHandler.class, MainServlet.class, "_inactiveRequestHandler", false);
    private ServiceRegistration<ModuleServiceLifecycle> _portalInitializedModuleServiceLifecycleServiceRegistration;
    private ServiceRegistration<ModuleServiceLifecycle> _portalPortletsInitializedModuleServiceLifecycleServiceRegistration;
    private PortalRequestProcessor _portalRequestProcessor;
    private ServiceRegistration<ServletContext> _servletContextServiceRegistration;
    private ServiceRegistration<ModuleServiceLifecycle> _systemCheckModuleServiceLifecycleServiceRegistration;

    public void destroy() {
        if (_log.isDebugEnabled()) {
            _log.debug("Destroy plugins");
        }
        this._portalInitializedModuleServiceLifecycleServiceRegistration.unregister();
        this._portalPortletsInitializedModuleServiceLifecycleServiceRegistration.unregister();
        this._servletContextServiceRegistration.unregister();
        this._systemCheckModuleServiceLifecycleServiceRegistration.unregister();
        PortalLifecycleUtil.flushDestroys();
        List<Portlet> portlets = PortletLocalServiceUtil.getPortlets();
        if (_log.isDebugEnabled()) {
            _log.debug("Destroy portlets");
        }
        try {
            this._destroyPortlets(portlets);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Destroy companies");
        }
        try {
            this._destroyCompanies();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Process global shutdown events");
        }
        try {
            EventsProcessorUtil.process("global.shutdown.events", PropsValues.GLOBAL_SHUTDOWN_EVENTS);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this._portalRequestProcessor.process(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this._portalRequestProcessor.process(httpServletRequest, httpServletResponse);
    }

    public void init() throws ServletException {
        String[] xmls;
        ServletContext servletContext;
        block46: {
            if (_log.isDebugEnabled()) {
                _log.debug("Initialize");
            }
            servletContext = this.getServletContext();
            servletContext.setAttribute(MainServlet.class.getName(), (Object)Boolean.TRUE);
            this._portalRequestProcessor = new PortalRequestProcessor(servletContext, this._init());
            if (_log.isDebugEnabled()) {
                _log.debug("Verify patch levels");
            }
            try {
                PatcherUtil.verifyPatchLevels();
            }
            catch (PatchInconsistencyException pie) {
                if (PropsValues.VERIFY_PATCH_LEVELS_DISABLED) break block46;
                _log.error("Stopping the server due to the inconsistent patch levels");
                if (_log.isWarnEnabled()) {
                    _log.warn("Set the property \"verify.patch.levels.disabled\" to override stopping the server due to the inconsistent patch levels", pie);
                }
                System.exit(0);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Verify JVM configuration");
        }
        if (_log.isWarnEnabled()) {
            TimeZone timeZone;
            String timeZoneID;
            if (!StringPool.DEFAULT_CHARSET_NAME.startsWith("UTF-")) {
                StringBundler sb = new StringBundler(4);
                sb.append("The default JVM character set \"");
                sb.append(StringPool.DEFAULT_CHARSET_NAME);
                sb.append("\" is not UTF. Please review the JVM property ");
                sb.append("\"file.encoding\".");
                _log.warn(sb.toString());
            }
            if (!Objects.equals("UTC", timeZoneID = (timeZone = TimeZone.getDefault()).getID()) && !Objects.equals("GMT", timeZoneID)) {
                StringBundler sb = new StringBundler(4);
                sb.append("The default JVM time zone \"");
                sb.append(timeZoneID);
                sb.append("\" is not UTC or GMT. Please review the JVM ");
                sb.append("property \"user.timezone\".");
                _log.warn(sb.toString());
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Process startup events");
        }
        try {
            StartupAction startupAction = new StartupAction();
            startupAction.run(null);
        }
        catch (Exception e) {
            _log.error(e, e);
            System.out.println("Stopping the server due to unexpected startup errors");
            System.exit(0);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Initialize plugin package");
        }
        PluginPackage pluginPackage = null;
        try {
            pluginPackage = PluginPackageUtil.readPluginPackageServletContext(servletContext);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Initialize portlets");
        }
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        try {
            portlets.addAll(this._initPortlets(pluginPackage));
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        try {
            this._initLayoutTemplates(pluginPackage);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Initialize social");
        }
        try {
            xmls = new String[]{HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-social.xml")), HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-social-ext.xml"))};
            SocialConfigurationUtil.read(PortalClassLoaderUtil.getClassLoader(), xmls);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Initialize themes");
        }
        try {
            xmls = new String[]{HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-look-and-feel.xml")), HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-look-and-feel-ext.xml"))};
            List<Theme> themes = ThemeLocalServiceUtil.init(servletContext, null, true, xmls, pluginPackage);
            servletContext.setAttribute("PLUGIN_THEMES", themes);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Initialize web settings");
        }
        try {
            String xml = HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/web.xml"));
            this._checkWebSettings(xml);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Initialize extension environment");
        }
        try {
            ExtRegistry.registerPortal(servletContext);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Process global startup events");
        }
        try {
            EventsProcessorUtil.process("global.startup.events", PropsValues.GLOBAL_STARTUP_EVENTS);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Initialize resource actions");
        }
        try {
            this._initResourceActions(portlets);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        try {
            this._initCompanies();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (StartupHelperUtil.isDBNew() && PropsValues.SETUP_WIZARD_ADD_SAMPLE_DATA) {
            try {
                SetupWizardSampleDataUtil.addSampleData(PortalInstances.getDefaultCompanyId());
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Initialize plugins");
        }
        try {
            HotDeployUtil.setCapturePrematureEvents(false);
            PortalLifecycleUtil.flushInits();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        servletContext.setAttribute("STARTUP_FINISHED", (Object)Boolean.TRUE);
        StartupHelperUtil.setStartupFinished(true);
        this._registerPortalInitialized();
        ThreadLocalCacheManager.clearAll(Lifecycle.REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        long companyId;
        if (_log.isDebugEnabled()) {
            _log.debug("Process service request");
        }
        if (this._processShutdownRequest(httpServletRequest, httpServletResponse)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Processed shutdown request");
            }
            return;
        }
        if (this._processMaintenanceRequest(httpServletRequest, httpServletResponse)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Processed maintenance request");
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Get company id");
        }
        if (this._processCompanyInactiveRequest(httpServletRequest, httpServletResponse, companyId = PortalInstances.getCompanyId(httpServletRequest))) {
            if (_log.isDebugEnabled()) {
                _log.debug("Processed company inactive request");
            }
            return;
        }
        try {
            if (this._processGroupInactiveRequest(httpServletRequest, httpServletResponse)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Processed site inactive request");
                }
                return;
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchLayoutException) {
                if (_log.isDebugEnabled()) {
                    _log.debug(e, e);
                }
            }
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Set portal port");
        }
        PortalUtil.setPortalInetSocketAddresses(httpServletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug("Check variables");
        }
        ServletContext servletContext = this.getServletContext();
        httpServletRequest.setAttribute("CTX", (Object)servletContext);
        if (_log.isDebugEnabled()) {
            _log.debug("Handle non-serializable request");
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Encrypt request");
        }
        httpServletRequest = this._encryptRequest(httpServletRequest, companyId);
        long userId = PortalUtil.getUserId(httpServletRequest);
        String remoteUser = this._getRemoteUser(httpServletRequest, userId);
        try {
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("Authenticate user id ", userId, " and remote user ", remoteUser));
            }
            userId = this._loginUser(httpServletRequest, httpServletResponse, userId, remoteUser);
            if (_log.isDebugEnabled()) {
                _log.debug("Authenticated user id " + userId);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Set session thread local");
        }
        PortalSessionThreadLocal.setHttpSession(httpServletRequest.getSession());
        if (_log.isDebugEnabled()) {
            _log.debug("Process service pre events");
        }
        if (this._processServicePre(httpServletRequest, httpServletResponse, userId)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Processing service pre events has errors");
            }
            return;
        }
        if (httpServletRequest.getAttribute(AbsoluteRedirectsResponse.class.getName()) != null) {
            if (_log.isDebugEnabled()) {
                String currentURL = PortalUtil.getCurrentURL(httpServletRequest);
                _log.debug("Current URL " + currentURL + " has absolute redirect");
            }
            return;
        }
        if (httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY") == null) {
            if (_log.isDebugEnabled()) {
                String currentURL = PortalUtil.getCurrentURL(httpServletRequest);
                _log.debug("Current URL " + currentURL + " does not have a theme display");
            }
            return;
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("Call parent service");
            }
            super.service(httpServletRequest, httpServletResponse);
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug("Process service post events");
            }
            try {
                EventsProcessorUtil.process("servlet.service.events.post", PropsValues.SERVLET_SERVICE_EVENTS_POST, httpServletRequest, httpServletResponse);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    private void _checkWebSettings(String xml) throws DocumentException {
        Document doc = UnsecureSAXReaderUtil.read(xml);
        Element root = doc.getRootElement();
        int timeout = PropsValues.SESSION_TIMEOUT;
        Element sessionConfig = root.element("session-config");
        if (sessionConfig != null) {
            String sessionTimeout = sessionConfig.elementText("session-timeout");
            timeout = GetterUtil.getInteger(sessionTimeout, timeout);
        }
        PropsUtil.set("session.timeout", String.valueOf(timeout));
        PropsValues.SESSION_TIMEOUT = timeout;
        I18nServlet.setLanguageIds(root);
        I18nFilter.setLanguageIds(I18nServlet.getLanguageIds());
    }

    private void _destroyCompanies() throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIds()) {
            this._destroyCompany(companyId);
        }
    }

    private void _destroyCompany(long companyId) {
        if (_log.isDebugEnabled()) {
            _log.debug("Process shutdown events");
        }
        try {
            EventsProcessorUtil.process("application.shutdown.events", PropsValues.APPLICATION_SHUTDOWN_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    private void _destroyPortlets(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            PortletInstanceFactoryUtil.destroy(portlet);
            Map<String, PortletFilter> portletFilters = portlet.getPortletFilters();
            for (PortletFilter portletFilter : portletFilters.values()) {
                PortletFilterFactory.destroy(portletFilter);
            }
        }
    }

    private HttpServletRequest _encryptRequest(HttpServletRequest httpServletRequest, long companyId) {
        boolean encryptRequest = ParamUtil.getBoolean(httpServletRequest, "shuo");
        if (!encryptRequest) {
            return httpServletRequest;
        }
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById(companyId);
            httpServletRequest = new EncryptedServletRequest((HttpServletRequest)httpServletRequest, company.getKeyObj());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpServletRequest;
    }

    private String _getRemoteUser(HttpServletRequest httpServletRequest, long userId) {
        HttpSession session;
        String jRemoteUser;
        String remoteUser = httpServletRequest.getRemoteUser();
        if (!PropsValues.PORTAL_JAAS_ENABLE && (jRemoteUser = (String)(session = httpServletRequest.getSession()).getAttribute("j_remoteuser")) != null) {
            remoteUser = jRemoteUser;
        }
        if (userId > 0L && remoteUser == null) {
            remoteUser = String.valueOf(userId);
        }
        return remoteUser;
    }

    private ModuleConfig _init() throws ServletException {
        try {
            this._initServlet();
            TilesUtil.loadDefinitions(this.getServletContext());
            return this._initModuleConfig();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initCompanies() throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("Initialize companies");
        }
        ServletContext servletContext = this.getServletContext();
        try {
            String[] webIds;
            for (String webId : webIds = PortalInstances.getWebIds()) {
                PortalInstances.initCompany(servletContext, webId);
            }
        }
        finally {
            CompanyThreadLocal.setCompanyId(PortalInstances.getDefaultCompanyId());
        }
    }

    private void _initLayoutTemplates(final PluginPackage pluginPackage) {
        ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
        serviceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            @Override
            public void dependenciesFulfilled() {
                try {
                    if (_log.isDebugEnabled()) {
                        _log.debug("Initialize layout templates");
                    }
                    ServletContext servletContext = MainServlet.this.getServletContext();
                    String[] xmls = new String[]{HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-layout-templates.xml")), HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-layout-templates-ext.xml"))};
                    List<LayoutTemplate> layoutTemplates = LayoutTemplateLocalServiceUtil.init(servletContext, xmls, pluginPackage);
                    servletContext.setAttribute("PLUGIN_LAYOUT_TEMPLATES", layoutTemplates);
                }
                catch (Exception e) {
                    _log.error(e, e);
                }
            }

            @Override
            public void destroy() {
            }
        });
        Registry registry = RegistryUtil.getRegistry();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (String langType : LayoutTemplateLocalServiceImpl.supportedLangTypes) {
            StringBundler sb = new StringBundler(5);
            sb.append("(&(language.type=");
            sb.append(langType);
            sb.append(")(objectClass=");
            sb.append(TemplateManager.class.getName());
            sb.append("))");
            Filter filter = registry.getFilter(sb.toString());
            filters.add(filter);
        }
        serviceDependencyManager.registerDependencies(filters.toArray(new Filter[0]));
    }

    private ModuleConfig _initModuleConfig() throws Exception {
        ModuleConfig moduleConfig = new ModuleConfig();
        ServletContext servletContext = this.getServletContext();
        ClassLoader classLoader = MainServlet.class.getClassLoader();
        try (InputStream inputStream = servletContext.getResourceAsStream("/WEB-INF/struts-config.xml");){
            Document document = SAXReaderUtil.read(inputStream, false);
            Element rootElement = document.getRootElement();
            Element globalForwardsElement = rootElement.element("global-forwards");
            for (Element forwardElement : globalForwardsElement.elements("forward")) {
                moduleConfig.addActionForward(new ActionForward(forwardElement.attributeValue("name"), forwardElement.attributeValue("path")));
            }
            Element actionMappingsElement = rootElement.element("action-mappings");
            for (Element actionElement : actionMappingsElement.elements("action")) {
                Action action = null;
                String type = actionElement.attributeValue("type");
                if (type != null) {
                    Class<?> clazz = classLoader.loadClass(actionElement.attributeValue("type"));
                    action = (Action)clazz.newInstance();
                }
                ActionMapping actionMapping = new ActionMapping(moduleConfig, actionElement.attributeValue("forward"), actionElement.attributeValue("path"), action);
                for (Element forwardElement : actionElement.elements("forward")) {
                    actionMapping.addActionForward(new ActionForward(forwardElement.attributeValue("name"), forwardElement.attributeValue("path")));
                }
                moduleConfig.addActionMapping(actionMapping);
            }
        }
        return moduleConfig;
    }

    private void _initPortletApp(Portlet portlet, ServletContext servletContext) throws PortletException {
        PortletApp portletApp = portlet.getPortletApp();
        PortletConfig portletConfig = PortletConfigFactoryUtil.create(portlet, servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        Set<PortletFilter> portletFilters = portletApp.getPortletFilters();
        for (PortletFilter portletFilter : portletFilters) {
            PortletFilterFactory.create(portletFilter, portletContext);
        }
        Set<PortletURLListener> portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    private List<Portlet> _initPortlets(PluginPackage pluginPackage) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[PropsValues.PORTLET_CONFIGS.length];
        for (int i = 0; i < PropsValues.PORTLET_CONFIGS.length; ++i) {
            xmls[i] = HttpUtil.URLtoString(servletContext.getResource(PropsValues.PORTLET_CONFIGS[i]));
        }
        PortletLocalServiceUtil.initEAR(servletContext, xmls, pluginPackage);
        PortletBagFactory portletBagFactory = new PortletBagFactory();
        portletBagFactory.setClassLoader(PortalClassLoaderUtil.getClassLoader());
        portletBagFactory.setServletContext(servletContext);
        portletBagFactory.setWARFile(false);
        List<Portlet> portlets = PortletLocalServiceUtil.getPortlets();
        for (int i = 0; i < portlets.size(); ++i) {
            Portlet portlet = portlets.get(i);
            portletBagFactory.create(portlet);
            if (i != 0) continue;
            this._initPortletApp(portlet, servletContext);
        }
        servletContext.setAttribute("PLUGIN_PORTLETS", portlets);
        return portlets;
    }

    private void _initResourceActions(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            List<String> portletActions = ResourceActionsUtil.getPortletResourceActions(portlet);
            ResourceActionLocalServiceUtil.checkResourceActions(portlet.getPortletId(), portletActions);
            List<String> modelNames = ResourceActionsUtil.getPortletModelResources(portlet.getPortletId());
            for (String modelName : modelNames) {
                List<String> modelActions = ResourceActionsUtil.getModelResourceActions(modelName);
                ResourceActionLocalServiceUtil.checkResourceActions(modelName, modelActions);
            }
        }
    }

    private void _initServlet() {
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = this.getServletContext();
        ServletRegistration servletRegistration = servletContext.getServletRegistration(servletConfig.getServletName());
        Collection mappings = servletRegistration.getMappings();
        Iterator iterator = mappings.iterator();
        if (iterator.hasNext()) {
            servletContext.setAttribute("SERVLET_MAPPING", iterator.next());
        }
    }

    private long _loginUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long userId, String remoteUser) throws PortalException {
        if (userId > 0L || remoteUser == null) {
            return userId;
        }
        userId = GetterUtil.getLong(remoteUser);
        User user = UserLocalServiceUtil.getUserById(userId);
        if (!user.isDefaultUser()) {
            EventsProcessorUtil.process("login.events.pre", PropsValues.LOGIN_EVENTS_PRE, httpServletRequest, httpServletResponse);
            if (PropsValues.USERS_UPDATE_LAST_LOGIN || user.getLastLoginDate() == null) {
                user = UserLocalServiceUtil.updateLastLogin(userId, httpServletRequest.getRemoteAddr());
            }
        }
        if (httpServletRequest.getAttribute("USER") != null) {
            httpServletRequest.setAttribute("USER", (Object)user);
            httpServletRequest.setAttribute("USER_ID", (Object)userId);
        }
        HttpSession session = httpServletRequest.getSession();
        session.setAttribute("LOCALE", (Object)user.getLocale());
        session.setAttribute("USER", (Object)user);
        session.setAttribute("USER_ID", (Object)userId);
        session.removeAttribute("j_remoteuser");
        if (!user.isDefaultUser()) {
            EventsProcessorUtil.process("login.events.post", PropsValues.LOGIN_EVENTS_POST, httpServletRequest, httpServletResponse);
        }
        return userId;
    }

    private boolean _processCompanyInactiveRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long companyId) throws IOException {
        if (PortalInstances.isCompanyActive(companyId)) {
            return false;
        }
        _inactiveRequestHandler.processInactiveRequest(httpServletRequest, httpServletResponse, "this-instance-is-inactive-please-contact-the-administrator");
        return true;
    }

    private boolean _processGroupInactiveRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, PortalException {
        long plid = ParamUtil.getLong(httpServletRequest, "p_l_id");
        if (plid <= 0L) {
            return false;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout(plid);
        Group group = layout.getGroup();
        if (GroupLocalServiceUtil.isLiveGroupActive(group)) {
            return false;
        }
        _inactiveRequestHandler.processInactiveRequest(httpServletRequest, httpServletResponse, "this-site-is-inactive-please-contact-the-administrator");
        return true;
    }

    private boolean _processMaintenanceRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (!MaintenanceUtil.isMaintaining()) {
            return false;
        }
        RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("/html/portal/maintenance.jsp");
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        return true;
    }

    private boolean _processServicePre(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long userId) throws IOException, ServletException {
        try {
            EventsProcessorUtil.process("servlet.service.events.pre", PropsValues.SERVLET_SERVICE_EVENTS_PRE, httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchLayoutException) {
                PortalUtil.sendError(404, (Exception)cause, httpServletRequest, httpServletResponse);
                return true;
            }
            if (cause instanceof PrincipalException) {
                this._processServicePrePrincipalException(cause, userId, httpServletRequest, httpServletResponse);
                return true;
            }
            _log.error(e, e);
            httpServletRequest.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            ServletContext servletContext = this.getServletContext();
            StrutsUtil.forward(PropsValues.SERVLET_SERVICE_EVENTS_PRE_ERROR_PAGE, servletContext, httpServletRequest, httpServletResponse);
            if (e == httpServletRequest.getAttribute("javax.servlet.jsp.jspException")) {
                httpServletRequest.removeAttribute("javax.servlet.jsp.jspException");
                httpServletRequest.removeAttribute("javax.servlet.error.exception");
                httpServletRequest.removeAttribute("javax.servlet.error.exception_type");
                httpServletRequest.removeAttribute("javax.servlet.error.message");
                httpServletRequest.removeAttribute("javax.servlet.error.request_uri");
                httpServletRequest.removeAttribute("javax.servlet.error.servlet_name");
                httpServletRequest.removeAttribute("javax.servlet.error.status_code");
            }
            return true;
        }
        if (!_HTTP_HEADER_VERSION_VERBOSITY_DEFAULT) {
            if (_HTTP_HEADER_VERSION_VERBOSITY_PARTIAL) {
                httpServletResponse.addHeader(_LIFERAY_PORTAL_REQUEST_HEADER, ReleaseInfo.getName());
            } else {
                httpServletResponse.addHeader(_LIFERAY_PORTAL_REQUEST_HEADER, ReleaseInfo.getReleaseInfo());
            }
        }
        return false;
    }

    private void _processServicePrePrincipalException(Throwable t, long userId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (userId > 0L || ParamUtil.getInteger(httpServletRequest, "p_p_lifecycle") == 2) {
            PortalUtil.sendError(401, (Exception)t, httpServletRequest, httpServletResponse);
            return;
        }
        String mainPath = PortalUtil.getPathMain();
        String redirect = mainPath.concat("/portal/login");
        String currentURL = PortalUtil.getCurrentURL(httpServletRequest);
        redirect = HttpUtil.addParameter(redirect, "redirect", currentURL);
        long plid = ParamUtil.getLong(httpServletRequest, "p_l_id");
        if (plid > 0L) {
            try {
                redirect = HttpUtil.addParameter(redirect, "refererPlid", plid);
                Layout layout = LayoutLocalServiceUtil.getLayout(plid);
                Group group = layout.getGroup();
                plid = group.getDefaultPublicPlid();
                if (plid == 0L || group.isStagingGroup()) {
                    Group guestGroup = GroupLocalServiceUtil.getGroup(layout.getCompanyId(), "Guest");
                    plid = guestGroup.getDefaultPublicPlid();
                }
                redirect = HttpUtil.addParameter(redirect, "p_l_id", plid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        httpServletResponse.sendRedirect(redirect);
    }

    private boolean _processShutdownRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (!ShutdownUtil.isShutdown()) {
            return false;
        }
        String messageKey = ShutdownUtil.getMessage();
        if (Validator.isNull(messageKey)) {
            messageKey = "the-system-is-shutdown-please-try-again-later";
        }
        _inactiveRequestHandler.processInactiveRequest(httpServletRequest, httpServletResponse, messageKey);
        return true;
    }

    private void _registerPortalInitialized() {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("module.service.lifecycle", "portal.initialized");
        properties.put("service.vendor", ReleaseInfo.getVendor());
        properties.put("service.version", ReleaseInfo.getVersion());
        this._portalInitializedModuleServiceLifecycleServiceRegistration = registry.registerService(ModuleServiceLifecycle.class, new ModuleServiceLifecycle(){}, properties);
        properties = new HashMap();
        properties.put("module.service.lifecycle", "portlets.initialized");
        properties.put("service.vendor", ReleaseInfo.getVendor());
        properties.put("service.version", ReleaseInfo.getVersion());
        this._portalPortletsInitializedModuleServiceLifecycleServiceRegistration = registry.registerService(ModuleServiceLifecycle.class, new ModuleServiceLifecycle(){}, properties);
        properties = new HashMap();
        properties.put("bean.id", ServletContext.class.getName());
        properties.put("original.bean", Boolean.TRUE);
        properties.put("service.vendor", ReleaseInfo.getVendor());
        this._servletContextServiceRegistration = registry.registerService(ServletContext.class, this.getServletContext(), properties);
        properties = new HashMap();
        properties.put("module.service.lifecycle", "system.check");
        properties.put("service.vendor", ReleaseInfo.getVendor());
        properties.put("service.version", ReleaseInfo.getVersion());
        this._systemCheckModuleServiceLifecycleServiceRegistration = registry.registerService(ModuleServiceLifecycle.class, new ModuleServiceLifecycle(){}, properties);
    }
}

