/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.increment;

import com.liferay.portal.internal.increment.BufferedIncrementConfiguration;
import com.liferay.portal.internal.increment.BufferedIncrementProcessor;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BufferedIncrementProcessorUtil {
    private static final Map<String, Map.Entry<BufferedIncrementConfiguration, BufferedIncrementProcessor>> _bufferedIncrementProcessors = new ConcurrentHashMap<String, Map.Entry<BufferedIncrementConfiguration, BufferedIncrementProcessor>>();

    public static BufferedIncrementProcessor getBufferedIncrementProcessor(String configuration) {
        Map.Entry entry = _bufferedIncrementProcessors.computeIfAbsent(configuration, key -> {
            BufferedIncrementConfiguration bufferedIncrementConfiguration = new BufferedIncrementConfiguration((String)key);
            BufferedIncrementProcessor bufferedIncrementProcessor = null;
            if (bufferedIncrementConfiguration.isEnabled()) {
                bufferedIncrementProcessor = new BufferedIncrementProcessor(bufferedIncrementConfiguration, (String)key);
            }
            return new AbstractMap.SimpleImmutableEntry<BufferedIncrementConfiguration, Object>(bufferedIncrementConfiguration, bufferedIncrementProcessor);
        });
        return (BufferedIncrementProcessor)entry.getValue();
    }

    public void destroy() {
        for (Map.Entry<BufferedIncrementConfiguration, BufferedIncrementProcessor> entry : _bufferedIncrementProcessors.values()) {
            BufferedIncrementProcessor bufferedIncrementProcessor = entry.getValue();
            if (bufferedIncrementProcessor == null) continue;
            bufferedIncrementProcessor.destroy();
        }
    }
}

