/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.increment;

import com.liferay.portal.internal.increment.BatchablePipe;
import com.liferay.portal.internal.increment.BufferedIncreasableEntry;
import com.liferay.portal.internal.increment.BufferedIncrementConfiguration;
import com.liferay.portal.internal.increment.BufferedIncrementRunnable;
import com.liferay.portal.kernel.increment.Increment;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BufferedIncrementProcessor {
    private final BatchablePipe<Serializable, Increment<?>> _batchablePipe = new BatchablePipe();
    private final BufferedIncrementConfiguration _bufferedIncrementConfiguration;
    private final ExecutorService _executorService;
    private final AtomicInteger _queueLengthTracker = new AtomicInteger();

    public BufferedIncrementProcessor(BufferedIncrementConfiguration bufferedIncrementConfiguration, String configuration) {
        this._bufferedIncrementConfiguration = bufferedIncrementConfiguration;
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, this._bufferedIncrementConfiguration.getThreadpoolMaxSize(), this._bufferedIncrementConfiguration.getThreadpoolKeepAliveTime(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        Thread currentThread = Thread.currentThread();
        threadPoolExecutor.setThreadFactory(new NamedThreadFactory("BufferedIncrement-".concat(configuration), 5, currentThread.getContextClassLoader()));
        this._executorService = threadPoolExecutor;
    }

    public void destroy() {
        this._executorService.shutdown();
    }

    public void process(BufferedIncreasableEntry bufferedIncreasableEntry) {
        if (this._batchablePipe.put(bufferedIncreasableEntry)) {
            BufferedIncrementRunnable runnable = new BufferedIncrementRunnable(this._bufferedIncrementConfiguration, this._batchablePipe, this._queueLengthTracker, Thread.currentThread());
            if (ProxyModeThreadLocal.isForceSync()) {
                runnable.run();
            } else {
                this._executorService.execute(runnable);
            }
        }
    }
}

