/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.dao.sql.transformer;

import com.liferay.portal.kernel.util.StringUtil;

public class SQLFunctionTransformer {
    private final String _functionPrefix;
    private final String _replacementDelimiter;
    private final String _replacementPrefix;
    private final String _replacementSuffix;

    public SQLFunctionTransformer(String functionPrefix, String replacementPrefix, String replacementDelimiter, String replacementSuffix) {
        if (!StringUtil.isUpperCase(functionPrefix) || !functionPrefix.endsWith("(")) {
            throw new IllegalArgumentException(functionPrefix);
        }
        if (replacementDelimiter.contains(functionPrefix)) {
            throw new IllegalArgumentException(replacementDelimiter);
        }
        if (replacementSuffix.contains(functionPrefix)) {
            throw new IllegalArgumentException(replacementSuffix);
        }
        this._functionPrefix = functionPrefix;
        this._replacementPrefix = replacementPrefix;
        this._replacementDelimiter = replacementDelimiter;
        this._replacementSuffix = replacementSuffix;
    }

    public String transform(String sql) {
        int pos = sql.indexOf(this._functionPrefix);
        if (pos < 0) {
            return sql;
        }
        StringBuilder sb = new StringBuilder(sql);
        while (pos >= 0) {
            sb.replace(pos, pos + this._functionPrefix.length(), this._replacementPrefix);
            int next = pos + this._replacementPrefix.length();
            int openParentheses = 1;
            while (true) {
                if (next == sb.length()) {
                    throw new IllegalArgumentException("Unclosed function in: " + sql);
                }
                char c = sb.charAt(next);
                if (c == ',') {
                    if (openParentheses == 1) {
                        sb.replace(next, next + 1, this._replacementDelimiter);
                        next += this._replacementDelimiter.length();
                        continue;
                    }
                } else if (c == ')') {
                    if (--openParentheses == 0) {
                        break;
                    }
                } else if (c == '(') {
                    ++openParentheses;
                } else if (c == '\'') {
                    next = sb.indexOf("'", next + 1);
                    while (next >= 0 && this._isEscaped(sb, next)) {
                        next = sb.indexOf("'", next + 1);
                    }
                    if (next < 0) {
                        throw new IllegalArgumentException("Unclosed string literal in: " + sql);
                    }
                }
                ++next;
            }
            sb.replace(next, next + 1, this._replacementSuffix);
            pos = sb.indexOf(this._functionPrefix, pos + this._replacementPrefix.length());
        }
        return sb.toString();
    }

    private boolean _isEscaped(StringBuilder sb, int index) {
        boolean escaped = false;
        while (sb.charAt(--index) == '\\') {
            escaped = !escaped;
        }
        return escaped;
    }
}

