/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.cluster;

import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutorUtil;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.cluster.ClusterableInvokerUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

public class ClusterableAdvice
extends ChainableMethodAdvice {
    @Override
    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        return annotations.get(Clusterable.class);
    }

    @Override
    protected void afterReturning(AopMethodInvocation aopMethodInvocation, Object[] arguments, Object result) throws Throwable {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        Clusterable clusterable = (Clusterable)aopMethodInvocation.getAdviceMethodContext();
        ClusterableInvokerUtil.invokeOnCluster(clusterable.acceptor(), aopMethodInvocation.getThis(), aopMethodInvocation.getMethod(), arguments);
    }

    @Override
    protected Object before(AopMethodInvocation aopMethodInvocation, Object[] arguments) throws Throwable {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return null;
        }
        Clusterable clusterable = (Clusterable)aopMethodInvocation.getAdviceMethodContext();
        if (!clusterable.onMaster()) {
            return null;
        }
        Object result = null;
        result = ClusterMasterExecutorUtil.isMaster() ? aopMethodInvocation.proceed(arguments) : ClusterableInvokerUtil.invokeOnMaster(clusterable.acceptor(), aopMethodInvocation.getThis(), aopMethodInvocation.getMethod(), arguments);
        Method method = aopMethodInvocation.getMethod();
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            result = nullResult;
        }
        return result;
    }
}

