/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.portal.image.BaseHook;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;

public class DLHook
extends BaseHook {
    private static final long _COMPANY_ID = 0L;
    private static final long _REPOSITORY_ID = 0L;

    @Override
    public void deleteImage(Image image) throws PortalException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        try {
            DLStoreUtil.deleteFile(0L, 0L, fileName);
        }
        catch (NoSuchFileException nsfe) {
            throw new NoSuchImageException(nsfe);
        }
    }

    @Override
    public byte[] getImageAsBytes(Image image) throws PortalException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        InputStream is = DLStoreUtil.getFileAsStream(0L, 0L, fileName);
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes(is);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
        return bytes;
    }

    @Override
    public InputStream getImageAsStream(Image image) throws PortalException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        return DLStoreUtil.getFileAsStream(0L, 0L, fileName);
    }

    @Override
    public void updateImage(Image image, String type, byte[] bytes) throws PortalException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        DLValidatorUtil.validateFileSize(fileName, bytes);
        if (DLStoreUtil.hasFile(0L, 0L, fileName)) {
            DLStoreUtil.deleteFile(0L, 0L, fileName);
        }
        DLStoreUtil.addFile(0L, 0L, fileName, true, bytes);
    }

    protected String getFileName(long imageId, String type) {
        return imageId + "." + type;
    }
}

