/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.status;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.fabric.status.AdvancedOperatingSystemMXBean;
import com.liferay.portal.fabric.status.FabricStatus;
import com.liferay.portal.fabric.status.JMXProxyUtil;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformLoggingMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;

public class RemoteFabricStatus
implements FabricStatus {
    protected final JMXProxyUtil.ProcessCallableExecutor processCallableExecutor;

    public RemoteFabricStatus(JMXProxyUtil.ProcessCallableExecutor processCallableExecutor) {
        this.processCallableExecutor = processCallableExecutor;
    }

    @Override
    public AdvancedOperatingSystemMXBean getAdvancedOperatingSystemMXBean() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        return JMXProxyUtil.newProxy(operatingSystemMXBean.getObjectName(), AdvancedOperatingSystemMXBean.class, this.processCallableExecutor);
    }

    @Override
    public List<BufferPoolMXBean> getBufferPoolMXBeans() {
        return RemoteFabricStatus.getPlatformMXBeans(BufferPoolMXBean.class, this.processCallableExecutor);
    }

    @Override
    public ClassLoadingMXBean getClassLoadingMXBean() {
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        return JMXProxyUtil.newProxy(classLoadingMXBean.getObjectName(), ClassLoadingMXBean.class, this.processCallableExecutor);
    }

    @Override
    public CompilationMXBean getCompilationMXBean() {
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        return JMXProxyUtil.newProxy(compilationMXBean.getObjectName(), CompilationMXBean.class, this.processCallableExecutor);
    }

    @Override
    public List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return RemoteFabricStatus.getPlatformMXBeans(GarbageCollectorMXBean.class, this.processCallableExecutor);
    }

    @Override
    public List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return RemoteFabricStatus.getPlatformMXBeans(MemoryManagerMXBean.class, this.processCallableExecutor);
    }

    @Override
    public MemoryMXBean getMemoryMXBean() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        return JMXProxyUtil.newProxy(memoryMXBean.getObjectName(), MemoryMXBean.class, this.processCallableExecutor);
    }

    @Override
    public List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return RemoteFabricStatus.getPlatformMXBeans(MemoryPoolMXBean.class, this.processCallableExecutor);
    }

    @Override
    public PlatformLoggingMXBean getPlatformLoggingMXBean() {
        PlatformLoggingMXBean platformLoggingMXBean = ManagementFactory.getPlatformMXBean(PlatformLoggingMXBean.class);
        return JMXProxyUtil.newProxy(platformLoggingMXBean.getObjectName(), PlatformLoggingMXBean.class, this.processCallableExecutor);
    }

    @Override
    public RuntimeMXBean getRuntimeMXBean() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return JMXProxyUtil.newProxy(runtimeMXBean.getObjectName(), RuntimeMXBean.class, this.processCallableExecutor);
    }

    @Override
    public ThreadMXBean getThreadMXBean() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return JMXProxyUtil.newProxy(threadMXBean.getObjectName(), ThreadMXBean.class, this.processCallableExecutor);
    }

    protected static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> mxBeanInterface, JMXProxyUtil.ProcessCallableExecutor processCallableExecutor) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            NoticeableFuture<ArrayList<ObjectName>> future = processCallableExecutor.execute(new GetPlatformMXBeanObjectNamesProcessCallable(mxBeanInterface));
            for (ObjectName objectName : (ArrayList)future.get()) {
                list.add(JMXProxyUtil.newProxy(objectName, mxBeanInterface, processCallableExecutor));
            }
        }
        catch (Exception e) {
            return (List)ReflectionUtil.throwException(e);
        }
        return list;
    }

    protected static class GetPlatformMXBeanObjectNamesProcessCallable
    implements ProcessCallable<ArrayList<ObjectName>> {
        private static final long serialVersionUID = 1L;
        private final Class<? extends PlatformManagedObject> _clazz;

        public GetPlatformMXBeanObjectNamesProcessCallable(Class<? extends PlatformManagedObject> clazz) {
            this._clazz = clazz;
        }

        @Override
        public ArrayList<ObjectName> call() {
            ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
            for (PlatformManagedObject platformManagedObject : ManagementFactory.getPlatformMXBeans(this._clazz)) {
                objectNames.add(platformManagedObject.getObjectName());
            }
            return objectNames;
        }
    }
}

