/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.status;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessException;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.PlatformManagedObject;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class JMXProxyUtil {
    public static <T> T newProxy(ObjectName objectName, Class<T> interfaceClass, ProcessCallableExecutor processCallableExecutor) {
        ClassLoader classLoader = interfaceClass.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{interfaceClass}, (InvocationHandler)new JMXProxyInvocationHandler(objectName, processCallableExecutor));
    }

    protected static Object decode(Class<?> decodedClass, Serializable serializable) {
        Class<?> clazz;
        if (serializable instanceof CompositeData) {
            return JMXProxyUtil.decodeCompositeData(decodedClass, (CompositeData)((Object)serializable));
        }
        if (serializable instanceof CompositeData[] && decodedClass.isArray()) {
            return JMXProxyUtil.decodeCompositeDataArray(decodedClass, (CompositeData[])serializable);
        }
        if (decodedClass == List.class && (clazz = serializable.getClass()).isArray()) {
            return JMXProxyUtil.decodeArrayToList(serializable);
        }
        return serializable;
    }

    protected static Object decodeArrayToList(Object array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < Array.getLength(array); ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    protected static Object decodeCompositeData(Class<?> decodedClass, CompositeData compositeData) {
        if (decodedClass == MemoryUsage.class) {
            return MemoryUsage.from(compositeData);
        }
        if (decodedClass == ThreadInfo.class) {
            return ThreadInfo.from(compositeData);
        }
        return compositeData;
    }

    protected static Object decodeCompositeDataArray(Class<?> decodedClass, CompositeData[] compositeDatas) {
        Object array = Array.newInstance(decodedClass.getComponentType(), compositeDatas.length);
        for (int i = 0; i < compositeDatas.length; ++i) {
            Array.set(array, i, JMXProxyUtil.decodeCompositeData(decodedClass.getComponentType(), compositeDatas[i]));
        }
        return array;
    }

    protected static boolean equals(ObjectName objectName, Object target) {
        InvocationHandler invocationHandler;
        if (target instanceof PlatformManagedObject) {
            PlatformManagedObject platformManagedObject = (PlatformManagedObject)target;
            return objectName.equals(platformManagedObject.getObjectName());
        }
        if (Proxy.isProxyClass(target.getClass()) && (invocationHandler = Proxy.getInvocationHandler(target)) instanceof JMXProxyInvocationHandler) {
            JMXProxyInvocationHandler jmxProxyInvocationHandler = (JMXProxyInvocationHandler)invocationHandler;
            return objectName.equals(jmxProxyInvocationHandler._objectName);
        }
        return false;
    }

    protected static boolean isGetGetter(String methodName, Class<?> ... parameterTypes) {
        return methodName.startsWith("get") && parameterTypes.length == 0;
    }

    protected static boolean isIsGetter(String methodName, Class<?> ... parameterTypes) {
        return methodName.startsWith("is") && parameterTypes.length == 0;
    }

    protected static boolean isObjectEquals(Method method) {
        String methodName;
        return method.getDeclaringClass() == Object.class && (methodName = method.getName()).equals("equals");
    }

    protected static boolean isObjectHashCode(Method method) {
        String methodName;
        return method.getDeclaringClass() == Object.class && (methodName = method.getName()).equals("hashCode");
    }

    protected static boolean isObjectToString(Method method) {
        String methodName;
        return method.getDeclaringClass() == Object.class && (methodName = method.getName()).equals("toString");
    }

    protected static boolean isOptional(Method method) {
        return method.getAnnotation(Optional.class) != null;
    }

    protected static boolean isSetter(String methodName, Class<?> ... parameterTypes) {
        return methodName.startsWith("set") && parameterTypes.length == 1;
    }

    protected static class SetAttributeProcessCallable
    implements ProcessCallable<Serializable> {
        private static final long serialVersionUID = 1L;
        private final String _attributeName;
        private final Serializable _attributeValue;
        private final ObjectName _objectName;
        private final boolean _optional;

        public SetAttributeProcessCallable(ObjectName objectName, String attributeName, Serializable attributeValue, boolean optional) {
            this._objectName = objectName;
            this._attributeName = attributeName;
            this._attributeValue = attributeValue;
            this._optional = optional;
        }

        @Override
        public Serializable call() throws ProcessException {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                mBeanServer.setAttribute(this._objectName, new Attribute(this._attributeName, this._attributeValue));
            }
            catch (AttributeNotFoundException anfe) {
                if (!this._optional) {
                    throw new ProcessException(anfe);
                }
            }
            catch (Exception e) {
                throw new ProcessException(e);
            }
            return null;
        }
    }

    protected static class OperationProcessCallable
    implements ProcessCallable<Serializable> {
        private static final long serialVersionUID = 1L;
        private final Object[] _arguments;
        private final ObjectName _objectName;
        private final String _operationName;
        private final String[] _parameterTypeNames;

        public OperationProcessCallable(ObjectName objectName, String operationName, Object[] arguments, String[] parameterTypeNames) {
            this._objectName = objectName;
            this._operationName = operationName;
            this._arguments = arguments;
            this._parameterTypeNames = parameterTypeNames;
        }

        @Override
        public Serializable call() throws ProcessException {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                return (Serializable)mBeanServer.invoke(this._objectName, this._operationName, this._arguments, this._parameterTypeNames);
            }
            catch (Exception e) {
                throw new ProcessException(e);
            }
        }
    }

    protected static class JMXProxyInvocationHandler
    implements InvocationHandler {
        private final ObjectName _objectName;
        private final ProcessCallableExecutor _processCallableExecutor;

        public JMXProxyInvocationHandler(ObjectName objectName, ProcessCallableExecutor processCallableExecutor) {
            this._objectName = objectName;
            this._processCallableExecutor = processCallableExecutor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (JMXProxyUtil.isObjectEquals(method)) {
                return JMXProxyUtil.equals(this._objectName, args[0]);
            }
            if (JMXProxyUtil.isObjectHashCode(method)) {
                return this._objectName.hashCode();
            }
            if (JMXProxyUtil.isObjectToString(method)) {
                return this._objectName.toString();
            }
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            ProcessCallable<Serializable> processCallable = null;
            if (JMXProxyUtil.isGetGetter(methodName, parameterTypes)) {
                processCallable = new GetAttributeProcessCallable(this._objectName, methodName.substring(3), JMXProxyUtil.isOptional(method));
            } else if (JMXProxyUtil.isIsGetter(methodName, parameterTypes)) {
                processCallable = new GetAttributeProcessCallable(this._objectName, methodName.substring(2), JMXProxyUtil.isOptional(method));
            } else if (JMXProxyUtil.isSetter(methodName, parameterTypes)) {
                processCallable = new SetAttributeProcessCallable(this._objectName, methodName.substring(3), (Serializable)args[0], JMXProxyUtil.isOptional(method));
            } else {
                String[] parameterTypeNames = new String[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameterTypeNames[i] = parameterTypes[i].getName();
                }
                processCallable = new OperationProcessCallable(this._objectName, methodName, args, parameterTypeNames);
            }
            NoticeableFuture<Serializable> future = this._processCallableExecutor.execute(processCallable);
            return JMXProxyUtil.decode(method.getReturnType(), (Serializable)future.get());
        }
    }

    protected static class GetAttributeProcessCallable
    implements ProcessCallable<Serializable> {
        private static final long serialVersionUID = 1L;
        private final String _attributeName;
        private final ObjectName _objectName;
        private final boolean _optional;

        public GetAttributeProcessCallable(ObjectName objectName, String attributeName, boolean optional) {
            this._objectName = objectName;
            this._attributeName = attributeName;
            this._optional = optional;
        }

        @Override
        public Serializable call() throws ProcessException {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                return (Serializable)mBeanServer.getAttribute(this._objectName, this._attributeName);
            }
            catch (AttributeNotFoundException anfe) {
                if (this._optional) {
                    return null;
                }
                throw new ProcessException(anfe);
            }
            catch (Exception e) {
                throw new ProcessException(e);
            }
        }
    }

    public static interface ProcessCallableExecutor {
        public <V extends Serializable> NoticeableFuture<V> execute(ProcessCallable<V> var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Optional {
    }
}

