/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.worker;

import com.liferay.petra.process.PathHolder;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessConfig;
import com.liferay.petra.process.ProcessException;
import com.liferay.util.SerializableUtil;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class NettyFabricWorkerConfig<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long _id;
    private final Map<PathHolder, PathHolder> _inputPathHolderMap;
    private final ProcessCallable<T> _processCallable;
    private final ProcessConfig _processConfig;

    public NettyFabricWorkerConfig(long id, ProcessConfig processConfig, ProcessCallable<T> processCallable, Map<Path, Path> inputPathMap) {
        if (processConfig == null) {
            throw new NullPointerException("Process config is null");
        }
        if (processCallable == null) {
            throw new NullPointerException("Process callable is null");
        }
        if (inputPathMap == null) {
            throw new NullPointerException("Input path map is null");
        }
        this._id = id;
        this._processConfig = processConfig;
        this._processCallable = new NettyFabricWorkerProcessCallable<T>(processCallable);
        this._inputPathHolderMap = new HashMap<PathHolder, PathHolder>();
        for (Map.Entry<Path, Path> entry : inputPathMap.entrySet()) {
            this._inputPathHolderMap.put(new PathHolder(entry.getKey()), new PathHolder(entry.getValue()));
        }
    }

    public long getId() {
        return this._id;
    }

    public Map<Path, Path> getInputPathMap() {
        HashMap<Path, Path> inputPathMap = new HashMap<Path, Path>();
        for (Map.Entry<PathHolder, PathHolder> entry : this._inputPathHolderMap.entrySet()) {
            PathHolder keyPathHolder = entry.getKey();
            PathHolder valuePathHolder = entry.getValue();
            inputPathMap.put(keyPathHolder.getPath(), valuePathHolder.getPath());
        }
        return inputPathMap;
    }

    public ProcessCallable<T> getProcessCallable() {
        return this._processCallable;
    }

    public ProcessConfig getProcessConfig() {
        return this._processConfig;
    }

    private static class NettyFabricWorkerProcessCallable<T extends Serializable>
    implements ProcessCallable<T> {
        private static final long serialVersionUID = 1L;
        private final byte[] _data;
        private final String _toString;

        public NettyFabricWorkerProcessCallable(ProcessCallable<T> processCallable) {
            this._data = SerializableUtil.serialize(processCallable);
            this._toString = processCallable.toString();
        }

        @Override
        public T call() throws ProcessException {
            ProcessCallable processCallable = (ProcessCallable)SerializableUtil.deserialize(this._data);
            return processCallable.call();
        }

        public String toString() {
            return this._toString;
        }
    }
}

