/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.util;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class NettyUtil {
    private static final Log _log = LogFactoryUtil.getLog(NettyUtil.class);

    public static void bindShutdown(EventExecutorGroup master, final EventExecutorGroup slave, final long quietPeriod, final long timeout) {
        io.netty.util.concurrent.Future future = master.terminationFuture();
        future.addListener((GenericFutureListener)new FutureListener<Object>(){

            public void operationComplete(io.netty.util.concurrent.Future<Object> future) throws InterruptedException {
                slave.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                if (!slave.awaitTermination(timeout, TimeUnit.MILLISECONDS) && _log.isWarnEnabled()) {
                    _log.warn("Bind shutdown timeout " + slave);
                }
            }
        });
    }

    public static ChannelPipeline createEmptyChannelPipeline() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
            }
        }});
        return channel.pipeline();
    }

    public static <T> void scheduleCancellation(Channel channel, final NoticeableFuture<T> noticeableFuture, long timeout) {
        EventLoop eventLoop = channel.eventLoop();
        ScheduledFuture cancellationFuture = eventLoop.schedule(new Runnable(){

            @Override
            public void run() {
                if (noticeableFuture.cancel(true) && _log.isWarnEnabled()) {
                    _log.warn("Cancelled timeout " + noticeableFuture);
                }
            }
        }, timeout, TimeUnit.MILLISECONDS);
        noticeableFuture.addFutureListener(new com.liferay.petra.concurrent.FutureListener<T>((Future)cancellationFuture, noticeableFuture){
            final /* synthetic */ Future val$cancellationFuture;
            final /* synthetic */ NoticeableFuture val$noticeableFuture;
            {
                this.val$cancellationFuture = future;
                this.val$noticeableFuture = noticeableFuture;
            }

            @Override
            public void complete(Future<T> future) {
                if (this.val$cancellationFuture.cancel(true) && _log.isDebugEnabled()) {
                    _log.debug("Cancelled scheduled cancellation for " + this.val$noticeableFuture);
                }
            }
        });
    }
}

