/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.handlers;

import com.liferay.petra.concurrent.AsyncBroker;
import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.portal.fabric.netty.agent.NettyFabricAgentStub;
import com.liferay.portal.fabric.netty.rpc.RPCUtil;
import com.liferay.portal.fabric.worker.FabricWorker;
import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public class NettyChannelAttributes {
    private static final AttributeKey<AsyncBroker<Long, Serializable>> _asyncBrokerKey = AttributeKey.valueOf((String)(RPCUtil.class.getName() + "-AsyncBroker"));
    private static final AttributeKey<Map<Long, FabricWorker<?>>> _fabricWorkersKey = AttributeKey.valueOf((String)(NettyChannelAttributes.class.getName() + "-FabricWorkers"));
    private static final AttributeKey<AtomicLong> _idGeneratorKey = AttributeKey.valueOf((String)(RPCUtil.class.getName() + "-IdGenerator"));
    private static final AttributeKey<NettyFabricAgentStub> _nettyFabricAgentStubKey = AttributeKey.valueOf((String)NettyFabricAgentStub.class.getName());

    public static <T extends Serializable> AsyncBroker<Long, T> getAsyncBroker(Channel channel) {
        AsyncBroker previousAsyncBroker;
        Attribute attribute = channel.attr(_asyncBrokerKey);
        AsyncBroker asyncBroker = (AsyncBroker)attribute.get();
        if (asyncBroker == null && (previousAsyncBroker = (AsyncBroker)attribute.setIfAbsent(asyncBroker = new AsyncBroker())) != null) {
            asyncBroker = previousAsyncBroker;
        }
        return asyncBroker;
    }

    public static <T extends Serializable> FabricWorker<T> getFabricWorker(Channel channel, long id) {
        Map<Long, FabricWorker<?>> fabricWorkers = NettyChannelAttributes.getFabricWorkers(channel);
        if (fabricWorkers == null) {
            return null;
        }
        return fabricWorkers.get(id);
    }

    public static Map<Long, FabricWorker<?>> getFabricWorkers(Channel channel) {
        Attribute attribute = channel.attr(_fabricWorkersKey);
        return (Map)attribute.get();
    }

    public static NettyFabricAgentStub getNettyFabricAgentStub(Channel channel) {
        Attribute attribute = channel.attr(_nettyFabricAgentStubKey);
        return (NettyFabricAgentStub)attribute.get();
    }

    public static long nextId(Channel channel) {
        AtomicLong previousAttachmentIdGenerator;
        Attribute attribute = channel.attr(_idGeneratorKey);
        AtomicLong attachmentIdGenerator = (AtomicLong)attribute.get();
        if (attachmentIdGenerator == null && (previousAttachmentIdGenerator = (AtomicLong)attribute.setIfAbsent((Object)(attachmentIdGenerator = new AtomicLong()))) != null) {
            attachmentIdGenerator = previousAttachmentIdGenerator;
        }
        return attachmentIdGenerator.getAndIncrement();
    }

    public static <T extends Serializable> void putFabricWorker(Channel channel, final long id, FabricWorker<T> fabricWorker) {
        Map previousFabricWorkers;
        Attribute attribute = channel.attr(_fabricWorkersKey);
        Map<Long, FabricWorker<Object>> fabricWorkers = (ConcurrentHashMap<Long, FabricWorker<T>>)attribute.get();
        if (fabricWorkers == null && (previousFabricWorkers = (Map)attribute.setIfAbsent(fabricWorkers = new ConcurrentHashMap<Long, FabricWorker<T>>())) != null) {
            fabricWorkers = previousFabricWorkers;
        }
        fabricWorkers.put(id, fabricWorker);
        NoticeableFuture noticeableFuture = fabricWorker.getProcessNoticeableFuture();
        final ConcurrentHashMap<Long, FabricWorker<T>> fabricWorkersRef = fabricWorkers;
        noticeableFuture.addFutureListener(new FutureListener<T>(){

            @Override
            public void complete(Future<T> future) {
                fabricWorkersRef.remove(id);
            }
        });
    }

    public static void setNettyFabricAgentStub(Channel channel, NettyFabricAgentStub nettyFabricAgentStub) {
        Attribute attribute = channel.attr(_nettyFabricAgentStubKey);
        attribute.set((Object)nettyFabricAgentStub);
    }
}

