/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.fileserver.handlers;

import com.liferay.petra.concurrent.AsyncBroker;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.fabric.netty.codec.serialization.ObjectDecodeChannelInboundHandler;
import com.liferay.portal.fabric.netty.fileserver.FileResponse;
import com.liferay.portal.fabric.netty.fileserver.handlers.FileUploadChannelHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.nio.file.Path;

public class FileResponseChannelHandler
extends ObjectDecodeChannelInboundHandler<FileResponse> {
    private static final Log _log = LogFactoryUtil.getLog(FileResponseChannelHandler.class);
    private final AsyncBroker<Path, FileResponse> _asyncBroker;
    private final EventExecutorGroup _eventExecutorGroup;

    public FileResponseChannelHandler(AsyncBroker<Path, FileResponse> asyncBroker, EventExecutorGroup eventExecutorGroup) {
        this._asyncBroker = asyncBroker;
        this._eventExecutorGroup = eventExecutorGroup;
    }

    @Override
    public FileResponse channelRead0(ChannelHandlerContext channelHandlerContext, FileResponse fileResponse, ByteBuf byteBuf) throws IOException {
        if (fileResponse.isFileNotFound() || fileResponse.isFileNotModified()) {
            if (!this._asyncBroker.takeWithResult(fileResponse.getPath(), fileResponse)) {
                _log.error(StringBundler.concat("Unable to place result ", fileResponse, " because no future exists with ID ", fileResponse.getPath()));
            }
            return null;
        }
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        channelPipeline.addFirst(new ChannelHandler[]{new FileUploadChannelHandler(this._asyncBroker, fileResponse, this._eventExecutorGroup.next())});
        channelPipeline.fireChannelRead((Object)byteBuf.retain());
        return null;
    }
}

