/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.fileserver;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.process.PathHolder;
import com.liferay.petra.string.StringBundler;
import java.io.Serializable;
import java.nio.file.Path;

public class FileResponse
implements Serializable {
    public static final long FILE_NOT_FOUND = 0L;
    public static final long FILE_NOT_MODIFIED = -1L;
    private static final long serialVersionUID = 1L;
    private final boolean _folder;
    private final long _lastModifiedTime;
    private transient Path _localFile;
    private final PathHolder _pathHolder;
    private final long _size;

    public FileResponse(Path path, long size, long lastModifiedTime, boolean folder) {
        this._size = size;
        this._lastModifiedTime = lastModifiedTime;
        this._folder = folder;
        this._pathHolder = new PathHolder(path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileResponse)) {
            return false;
        }
        FileResponse fileResponse = (FileResponse)obj;
        return this._folder == fileResponse._folder && this._lastModifiedTime == fileResponse._lastModifiedTime && this._pathHolder.equals(fileResponse._pathHolder) && this._size == fileResponse._size;
    }

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public Path getLocalFile() {
        return this._localFile;
    }

    public Path getPath() {
        return this._pathHolder.getPath();
    }

    public long getSize() {
        return this._size;
    }

    public int hashCode() {
        int hash = HashUtil.hash(0, this._folder);
        hash = HashUtil.hash(hash, this._lastModifiedTime);
        hash = HashUtil.hash(hash, this._pathHolder);
        hash = HashUtil.hash(hash, this._size);
        return hash;
    }

    public boolean isFileNotFound() {
        return this._size == 0L;
    }

    public boolean isFileNotModified() {
        return this._size == -1L;
    }

    public boolean isFolder() {
        return this._folder;
    }

    public void setLocalFile(Path localFile) {
        this._localFile = localFile;
    }

    public String toString() {
        StringBundler sb = new StringBundler(this._size > 0L ? 11 : 10);
        sb.append("{folder=");
        sb.append(this._folder);
        sb.append(", lastModifiedTime=");
        sb.append(this._lastModifiedTime);
        sb.append(", localFile=");
        sb.append(this._localFile);
        sb.append(", pathHolder=");
        sb.append(this._pathHolder);
        if (this._size == 0L) {
            sb.append(", status=File Not Found");
        } else if (this._size == -1L) {
            sb.append(", status=File Not Modified");
        } else {
            sb.append(", size=");
            sb.append(this._size);
        }
        sb.append("}");
        return sb.toString();
    }
}

