/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.local.agent;

import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessConfig;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.portal.fabric.agent.FabricAgent;
import com.liferay.portal.fabric.local.worker.LocalFabricWorker;
import com.liferay.portal.fabric.status.FabricStatus;
import com.liferay.portal.fabric.status.LocalFabricStatus;
import com.liferay.portal.fabric.worker.FabricWorker;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;

public class LocalFabricAgent
implements FabricAgent {
    private final Queue<FabricWorker<?>> _fabricWorkerQueue = new ConcurrentLinkedQueue();
    private final ProcessExecutor _processExecutor;

    public LocalFabricAgent(ProcessExecutor processExecutor) {
        this._processExecutor = processExecutor;
    }

    @Override
    public <T extends Serializable> FabricWorker<T> execute(ProcessConfig processConfig, ProcessCallable<T> processCallable) throws ProcessException {
        final LocalFabricWorker<T> fabricWorker = new LocalFabricWorker<T>(this._processExecutor.execute(processConfig, processCallable));
        this._fabricWorkerQueue.add(fabricWorker);
        NoticeableFuture noticeableFuture = fabricWorker.getProcessNoticeableFuture();
        noticeableFuture.addFutureListener(new FutureListener<T>(){

            @Override
            public void complete(Future<T> future) {
                LocalFabricAgent.this._fabricWorkerQueue.remove(fabricWorker);
            }
        });
        return fabricWorker;
    }

    @Override
    public FabricStatus getFabricStatus() {
        return LocalFabricStatus.INSTANCE;
    }

    @Override
    public Collection<? extends FabricWorker<?>> getFabricWorkers() {
        return Collections.unmodifiableCollection(this._fabricWorkerQueue);
    }
}

