/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.agent;

import com.liferay.petra.concurrent.BaseFutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessException;
import com.liferay.portal.fabric.agent.FabricAgent;
import com.liferay.portal.fabric.agent.FabricAgentListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import java.io.Serializable;
import java.util.concurrent.Future;

public class PortalClassPathWarmupFabricAgentListener
implements FabricAgentListener {
    private static final Log _log = LogFactoryUtil.getLog(PortalClassPathWarmupFabricAgentListener.class);
    private static final ProcessCallable<Serializable> _warmupProcessCallable = new ProcessCallable<Serializable>(){
        private static final long serialVersionUID = 1L;

        @Override
        public String call() {
            if (_log.isInfoEnabled()) {
                _log.info("Portal class path warmup successful");
            }
            return null;
        }
    };

    @Override
    public void registered(FabricAgent fabricAgent) {
        try {
            long startTime = System.currentTimeMillis();
            ProcessChannel fabricWorker = fabricAgent.execute(PortalClassPathUtil.getPortalProcessConfig(), (ProcessCallable)_warmupProcessCallable);
            NoticeableFuture<Serializable> noticeableFuture = fabricWorker.getProcessNoticeableFuture();
            noticeableFuture.addFutureListener(new FinishFutureListener(startTime));
        }
        catch (ProcessException pe) {
            _log.error("Unable to start portal class path warmup fabric worker", pe);
        }
    }

    @Override
    public void unregistered(FabricAgent fabricAgent) {
    }

    protected class FinishFutureListener
    extends BaseFutureListener<Serializable> {
        private final long _startTime;

        public FinishFutureListener(long startTime) {
            this._startTime = startTime;
        }

        @Override
        public void completeWithCancel(Future<Serializable> future) {
            _log.error("Portal class path warmup cancelled");
        }

        @Override
        public void completeWithException(Future<Serializable> future, Throwable throwable) {
            _log.error("Portal class path warmup failed", throwable);
        }

        @Override
        public void completeWithResult(Future<Serializable> future, Serializable result) {
            if (_log.isInfoEnabled()) {
                _log.info("Portal class path warmup finished successfully in " + (System.currentTimeMillis() - this._startTime) + "ms");
            }
        }
    }
}

