/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.events.ShutdownHook;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.fabric.server.FabricServerUtil;
import com.liferay.portal.jericho.CachedLoggerProvider;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.mailbox.MailboxDatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.messaging.MessageDatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.proxy.IntrabandProxyDatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.rpc.RPCDatagramReceiveHandler;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Direction;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.DistributedRegistry;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.MatchType;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import com.liferay.taglib.servlet.JspFactorySwapper;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

public class StartupAction
extends SimpleAction {
    private static final Log _log = LogFactoryUtil.getLog(StartupAction.class);

    @Override
    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(ids);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ActionException(e);
        }
    }

    protected void doRun(String[] ids) throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("com/liferay/portal/events/dependencies/startup.txt");){
            System.out.println(IOUtils.toString((InputStream)inputStream));
        }
        System.out.println("Starting " + ReleaseInfo.getReleaseInfo() + "\n");
        StartupHelperUtil.printPatchLevel();
        if (PropsValues.PORTAL_RESILIENCY_ENABLED) {
            ServiceDependencyManager portalResiliencyServiceDependencyManager = new ServiceDependencyManager();
            portalResiliencyServiceDependencyManager.addServiceDependencyListener(new PortalResiliencyServiceDependencyLister());
            portalResiliencyServiceDependencyManager.registerDependencies(MessageBus.class, PortalExecutorManager.class);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Add shutdown hook");
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(new ShutdownHook()));
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.MYSQL && GetterUtil.getFloat(db.getVersionString()) < 5.6f) {
            _log.error("Please upgrade to at least MySQL 5.6.4. The portal no longer supports older versions of MySQL.");
            System.exit(1);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Check required build number");
        }
        DBUpgrader.checkRequiredBuildNumber(ReleaseInfo.getParentBuildNumber());
        if (!PortalUpgradeProcess.isInRequiredSchemaVersion(DataAccess.getConnection())) {
            String msg = "You must first upgrade the portal core to the required schema version " + PortalUpgradeProcess.getRequiredSchemaVersion();
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("module.service.lifecycle", "database.initialized");
        properties.put("service.vendor", ReleaseInfo.getVendor());
        properties.put("service.version", ReleaseInfo.getVersion());
        final ServiceRegistration<1> moduleServiceLifecycleServiceRegistration = registry.registerService(ModuleServiceLifecycle.class, new ModuleServiceLifecycle(){}, properties);
        PortalLifecycleUtil.register(new BasePortalLifecycle(){

            @Override
            protected void doPortalDestroy() {
                moduleServiceLifecycleServiceRegistration.unregister();
            }

            @Override
            protected void doPortalInit() {
            }
        }, 1);
        if (_log.isDebugEnabled()) {
            _log.debug("Check class names");
        }
        ClassNameLocalServiceUtil.checkClassNames();
        if (_log.isDebugEnabled()) {
            _log.debug("Check resource actions");
        }
        ResourceActionLocalServiceUtil.checkResourceActions();
        if (_log.isDebugEnabled()) {
            _log.debug("Verify database");
        }
        DBUpgrader.verify();
        JspFactorySwapper.swap();
        CachedLoggerProvider.install();
    }

    private static class PortalResiliencyServiceDependencyLister
    implements ServiceDependencyListener {
        private PortalResiliencyServiceDependencyLister() {
        }

        @Override
        public void dependenciesFulfilled() {
            try {
                DistributedRegistry.registerDistributed("javax.portlet.markup.head.element", Direction.DUPLEX, MatchType.EXACT);
                DistributedRegistry.registerDistributed("javax.portlet.lifecycle_phase", Direction.DUPLEX, MatchType.EXACT);
                DistributedRegistry.registerDistributed(WebKeys.class);
                Intraband intraband = MPIHelperUtil.getIntraband();
                intraband.registerDatagramReceiveHandler(SystemDataType.MAILBOX.getValue(), new MailboxDatagramReceiveHandler());
                intraband.registerDatagramReceiveHandler(SystemDataType.MESSAGE.getValue(), new MessageDatagramReceiveHandler());
                intraband.registerDatagramReceiveHandler(SystemDataType.PROXY.getValue(), new IntrabandProxyDatagramReceiveHandler());
                intraband.registerDatagramReceiveHandler(SystemDataType.RPC.getValue(), new RPCDatagramReceiveHandler());
                if (PropsValues.PORTAL_FABRIC_ENABLED) {
                    FabricServerUtil.start();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to initialize portal resiliency", e);
            }
        }

        @Override
        public void destroy() {
        }
    }
}

