/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Map;

public class ShutdownHook
implements Runnable {
    @Override
    public void run() {
        if (GetterUtil.getBoolean(System.getProperty("shutdown.hook.print.full.thread.dump"))) {
            this.printFullThreadDump();
        }
    }

    protected void printFullThreadDump() {
        StringBundler sb = new StringBundler();
        sb.append("Full thread dump ");
        sb.append(System.getProperty("java.vm.name"));
        sb.append(" ");
        sb.append(System.getProperty("java.vm.version"));
        sb.append("\n\n");
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] elements = entry.getValue();
            sb.append("\"");
            sb.append(thread.getName());
            sb.append("\"");
            ThreadGroup threadGroup = thread.getThreadGroup();
            if (threadGroup != null) {
                sb.append(" (");
                sb.append(threadGroup.getName());
                sb.append(")");
            }
            sb.append(", priority=");
            sb.append(thread.getPriority());
            sb.append(", id=");
            sb.append(thread.getId());
            sb.append(", state=");
            sb.append((Object)thread.getState());
            sb.append("\n");
            for (StackTraceElement element : elements) {
                sb.append("\t");
                sb.append(element);
                sb.append("\n");
            }
            sb.append("\n");
        }
        System.out.println(sb);
    }
}

