/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.LayoutPermissionException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SessionParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.theme.ThemeDisplayFactory;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.LayoutTypeAccessPolicyTracker;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.StopWatch;

public class ServicePreAction
extends Action {
    protected File privateLARFile;
    protected File publicLARFile;
    private static final String _PATH_MAIN = PortalUtil.getPathMain();
    private static final String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static final String _PATH_PORTAL_LOGIN = "/portal/login";
    private static final String _PATH_PORTAL_LOGOUT = "/portal/logout";
    private static final String _PATH_PROXY;
    private static final Log _log;
    private static final Map<String, String> _portalDomains;

    public ServicePreAction() {
        this._initImportLARFiles();
    }

    @Override
    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this._servicePre(httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            throw new ActionException(e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Running takes " + stopWatch.getTime() + " ms");
        }
    }

    private static String _getPortalDomain(String portalURL) {
        String portalDomain = _portalDomains.get(portalURL);
        if (portalDomain == null) {
            portalDomain = HttpUtil.getDomain(portalURL);
            _portalDomains.put(portalURL, portalDomain);
        }
        return portalDomain;
    }

    private void _addDefaultLayoutsByLAR(long userId, long groupId, boolean privateLayout, File larFile) throws PortalException {
        User user = UserLocalServiceUtil.getUser(userId);
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_ARCHIVED_SETUPS_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_CONTROL_DEFAULT", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_USER_PREFERENCES_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        Map<String, Serializable> importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap(user, groupId, privateLayout, null, parameterMap);
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration(user.getUserId(), 6, importLayoutSettingsMap);
        ExportImportLocalServiceUtil.importLayouts(exportImportConfiguration, larFile);
    }

    private void _addDefaultUserPrivateLayoutByProperties(long userId, long groupId) throws PortalException {
        String friendlyURL = this._getFriendlyURL(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = LayoutLocalServiceUtil.addLayout(userId, groupId, true, 0L, PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_NAME, "", "", "portlet", false, friendlyURL, serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_TEMPLATE_ID, false);
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        for (String columnId : layoutTemplate.getColumns()) {
            String keyPrefix = "default.user.private.layout.";
            String portletIds = PropsUtil.get(keyPrefix.concat(columnId));
            layoutTypePortlet.addPortletIds(0L, StringUtil.split(portletIds), columnId, false);
        }
        LayoutLocalServiceUtil.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            LayoutSetLocalServiceUtil.updateLayoutSet(layoutSet);
        }
    }

    private void _addDefaultUserPrivateLayouts(User user) throws PortalException {
        Group group = user.getGroup();
        if (this.privateLARFile != null) {
            this._addDefaultLayoutsByLAR(user.getUserId(), group.getGroupId(), true, this.privateLARFile);
        } else {
            this._addDefaultUserPrivateLayoutByProperties(user.getUserId(), group.getGroupId());
        }
    }

    private void _addDefaultUserPublicLayoutByProperties(long userId, long groupId) throws PortalException {
        String friendlyURL = this._getFriendlyURL(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = LayoutLocalServiceUtil.addLayout(userId, groupId, false, 0L, PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_NAME, "", "", "portlet", false, friendlyURL, serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_TEMPLATE_ID, false);
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        for (String columnId : layoutTemplate.getColumns()) {
            String keyPrefix = "default.user.public.layout.";
            String portletIds = PropsUtil.get(keyPrefix.concat(columnId));
            layoutTypePortlet.addPortletIds(0L, StringUtil.split(portletIds), columnId, false);
        }
        LayoutLocalServiceUtil.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            LayoutSetLocalServiceUtil.updateLayoutSet(layoutSet);
        }
    }

    private void _addDefaultUserPublicLayouts(User user) throws PortalException {
        Group userGroup = user.getGroup();
        if (this.publicLARFile != null) {
            this._addDefaultLayoutsByLAR(user.getUserId(), userGroup.getGroupId(), false, this.publicLARFile);
        } else {
            this._addDefaultUserPublicLayoutByProperties(user.getUserId(), userGroup.getGroupId());
        }
    }

    private void _deleteDefaultUserPrivateLayouts(User user) throws PortalException {
        Group group = user.getGroup();
        ServiceContext serviceContext = new ServiceContext();
        LayoutLocalServiceUtil.deleteLayouts(group.getGroupId(), true, serviceContext);
    }

    private void _deleteDefaultUserPublicLayouts(User user) throws PortalException {
        Group userGroup = user.getGroup();
        ServiceContext serviceContext = new ServiceContext();
        LayoutLocalServiceUtil.deleteLayouts(userGroup.getGroupId(), false, serviceContext);
    }

    private LayoutComposite _getDefaultUserPersonalSiteLayoutComposite(User user) {
        Layout layout = null;
        Group group = user.getGroup();
        List<Layout> layouts = LayoutLocalServiceUtil.getLayouts(group.getGroupId(), true, 0L);
        if (layouts.isEmpty()) {
            layouts = LayoutLocalServiceUtil.getLayouts(group.getGroupId(), false, 0L);
        }
        if (!layouts.isEmpty()) {
            layout = layouts.get(0);
        }
        return new LayoutComposite(layout, layouts);
    }

    private LayoutComposite _getDefaultUserSitesLayoutComposite(final User user) throws PortalException {
        final LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
        groupParams.put("usersGroups", user.getUserId());
        int count = GroupLocalServiceUtil.searchCount(user.getCompanyId(), null, null, groupParams);
        final IntervalActionProcessor<LayoutComposite> intervalActionProcessor = new IntervalActionProcessor<LayoutComposite>(count);
        intervalActionProcessor.setPerformIntervalActionMethod(new IntervalActionProcessor.PerformIntervalActionMethod<LayoutComposite>(){

            @Override
            public LayoutComposite performIntervalAction(int start, int end) {
                List<Group> groups = GroupLocalServiceUtil.search(user.getCompanyId(), null, null, (LinkedHashMap<String, Object>)groupParams, start, end);
                for (Group group : groups) {
                    List<Layout> layouts = LayoutLocalServiceUtil.getLayouts(group.getGroupId(), true, 0L);
                    if (layouts.isEmpty()) {
                        layouts = LayoutLocalServiceUtil.getLayouts(group.getGroupId(), false, 0L);
                    }
                    if (layouts.isEmpty()) continue;
                    return new LayoutComposite(layouts.get(0), layouts);
                }
                intervalActionProcessor.incrementStart(groups.size());
                return null;
            }
        });
        LayoutComposite layoutComposite = (LayoutComposite)intervalActionProcessor.performIntervalActions();
        if (layoutComposite == null) {
            return new LayoutComposite(null, new ArrayList<Layout>());
        }
        return layoutComposite;
    }

    private LayoutComposite _getDefaultViewableLayoutComposite(HttpServletRequest httpServletRequest, User user, PermissionChecker permissionChecker, boolean signedIn, boolean ignoreHiddenLayouts) throws PortalException {
        LayoutComposite defaultLayoutComposite = this._getDefaultVirtualHostLayoutComposite(httpServletRequest);
        if (ListUtil.isNotEmpty((defaultLayoutComposite = this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, defaultLayoutComposite.getLayout(), defaultLayoutComposite.getLayouts(), ignoreHiddenLayouts)).getLayouts())) {
            return defaultLayoutComposite;
        }
        if (signedIn) {
            defaultLayoutComposite = this._getDefaultUserPersonalSiteLayoutComposite(user);
            if (defaultLayoutComposite.getLayout() == null) {
                defaultLayoutComposite = this._getDefaultUserSitesLayoutComposite(user);
            }
            if (ListUtil.isNotEmpty((defaultLayoutComposite = this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, defaultLayoutComposite.getLayout(), defaultLayoutComposite.getLayouts(), ignoreHiddenLayouts)).getLayouts())) {
                return defaultLayoutComposite;
            }
        }
        defaultLayoutComposite = this._getGuestSiteLayoutComposite(user);
        return this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, defaultLayoutComposite.getLayout(), defaultLayoutComposite.getLayouts(), ignoreHiddenLayouts);
    }

    private LayoutComposite _getDefaultVirtualHostLayoutComposite(HttpServletRequest httpServletRequest) throws PortalException {
        LayoutModel layout = null;
        List<Layout> layouts = null;
        LayoutSet layoutSet = (LayoutSet)httpServletRequest.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null) {
            layouts = LayoutLocalServiceUtil.getLayouts(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), 0L);
            Group group = null;
            if (!layouts.isEmpty()) {
                layout = layouts.get(0);
                group = layout.getGroup();
            }
            if (layout != null && layout.isPrivateLayout()) {
                layouts = LayoutLocalServiceUtil.getLayouts(group.getGroupId(), false, 0L);
                if (!layouts.isEmpty()) {
                    layout = layouts.get(0);
                } else {
                    group = null;
                    layout = null;
                }
            }
            if (group != null && group.isStagingGroup()) {
                Group liveGroup = group.getLiveGroup();
                layouts = LayoutLocalServiceUtil.getLayouts(liveGroup.getGroupId(), false, 0L);
                layout = !layouts.isEmpty() ? layouts.get(0) : null;
            }
        }
        return new LayoutComposite((Layout)layout, layouts);
    }

    private String _getFriendlyURL(String friendlyURL) {
        friendlyURL = GetterUtil.getString(friendlyURL);
        return FriendlyURLNormalizerUtil.normalize(friendlyURL);
    }

    private LayoutComposite _getGuestSiteLayoutComposite(User user) throws PortalException {
        Layout layout = null;
        List<Layout> layouts = null;
        Group guestGroup = GroupLocalServiceUtil.getGroup(user.getCompanyId(), "Guest");
        layouts = LayoutLocalServiceUtil.getLayouts(guestGroup.getGroupId(), false, 0L);
        if (!layouts.isEmpty()) {
            layout = layouts.get(0);
        }
        return new LayoutComposite(layout, layouts);
    }

    private LayoutComposite _getViewableLayoutComposite(HttpServletRequest httpServletRequest, User user, PermissionChecker permissionChecker, Layout layout, List<Layout> layouts, boolean ignoreHiddenLayouts) throws PortalException {
        if (layouts == null || layouts.isEmpty()) {
            return new LayoutComposite(layout, layouts);
        }
        boolean hasViewLayoutPermission = false;
        if (this._hasAccessPermission(permissionChecker, layout, false)) {
            hasViewLayoutPermission = true;
        }
        ArrayList<Layout> accessibleLayouts = new ArrayList<Layout>();
        for (Layout curLayout : layouts) {
            if (!ignoreHiddenLayouts && curLayout.isHidden() || !this._hasAccessPermission(permissionChecker, curLayout, false)) continue;
            if (accessibleLayouts.isEmpty() && !hasViewLayoutPermission) {
                layout = curLayout;
            }
            accessibleLayouts.add(curLayout);
        }
        if (accessibleLayouts.isEmpty()) {
            layouts = null;
            if (!this._isLoginRequest(httpServletRequest) && !hasViewLayoutPermission) {
                if (user.isDefaultUser() && PropsValues.AUTH_LOGIN_PROMPT_ENABLED) {
                    throw new PrincipalException.MustBeAuthenticated(String.valueOf(user.getUserId()));
                }
                SessionErrors.add(httpServletRequest, LayoutPermissionException.class.getName());
            }
        } else {
            layouts = accessibleLayouts;
        }
        return new LayoutComposite(layout, layouts);
    }

    private boolean _hasAccessPermission(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup) throws PortalException {
        return LayoutPermissionUtil.contains(permissionChecker, layout, checkViewableGroup, "VIEW");
    }

    private Boolean _hasPowerUserRole(User user) throws Exception {
        return RoleLocalServiceUtil.hasUserRole(user.getUserId(), user.getCompanyId(), "Power User", true);
    }

    private void _initImportLARFiles() {
        String privateLARFileName = PropsValues.DEFAULT_USER_PRIVATE_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug("Reading private LAR file " + privateLARFileName);
        }
        if (Validator.isNotNull(privateLARFileName)) {
            this.privateLARFile = new File(privateLARFileName);
            if (!this.privateLARFile.exists()) {
                _log.error("Private LAR file " + this.privateLARFile + " does not exist");
                this.privateLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug("Using private LAR file " + privateLARFileName);
            }
        }
        String publicLARFileName = PropsValues.DEFAULT_USER_PUBLIC_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug("Reading public LAR file " + publicLARFileName);
        }
        if (Validator.isNotNull(publicLARFileName)) {
            this.publicLARFile = new File(publicLARFileName);
            if (!this.publicLARFile.exists()) {
                _log.error("Public LAR file " + this.publicLARFile + " does not exist");
                this.publicLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug("Using public LAR file " + publicLARFileName);
            }
        }
    }

    private ThemeDisplay _initThemeDisplay(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Group refererLayoutGroup;
        Layout refererLayout;
        boolean themeJsBarebone;
        long sourceGroupId;
        Group layoutGroup;
        PermissionChecker permissionChecker;
        boolean signedIn;
        HttpSession session = httpServletRequest.getSession();
        Company company = PortalUtil.getCompany(httpServletRequest);
        String cdnHost = PortalUtil.getCDNHost(httpServletRequest);
        String dynamicResourcesCDNHost = "";
        boolean cdnDynamicResourceEnabled = PortalUtil.isCDNDynamicResourcesEnabled(httpServletRequest);
        if (cdnDynamicResourceEnabled) {
            dynamicResourcesCDNHost = cdnHost;
        }
        String portalURL = PortalUtil.getPortalURL(httpServletRequest);
        String contextPath = PortalUtil.getPathContext();
        String friendlyURLPrivateGroupPath = PortalUtil.getPathFriendlyURLPrivateGroup();
        String friendlyURLPrivateUserPath = PortalUtil.getPathFriendlyURLPrivateUser();
        String friendlyURLPublicPath = PortalUtil.getPathFriendlyURLPublic();
        String imagePath = dynamicResourcesCDNHost.concat(PortalUtil.getPathImage());
        String mainPath = _PATH_MAIN;
        String i18nPath = (String)httpServletRequest.getAttribute("I18N_PATH");
        if (Validator.isNotNull(i18nPath)) {
            if (Validator.isNotNull(contextPath)) {
                String i18nContextPath = contextPath.concat(i18nPath);
                friendlyURLPrivateGroupPath = StringUtil.replaceFirst(friendlyURLPrivateGroupPath, contextPath, i18nContextPath);
                friendlyURLPrivateUserPath = StringUtil.replaceFirst(friendlyURLPrivateUserPath, contextPath, i18nContextPath);
                friendlyURLPublicPath = StringUtil.replaceFirst(friendlyURLPublicPath, contextPath, i18nContextPath);
                mainPath = StringUtil.replaceFirst(mainPath, contextPath, i18nContextPath);
            } else {
                friendlyURLPrivateGroupPath = i18nPath.concat(friendlyURLPrivateGroupPath);
                friendlyURLPrivateUserPath = i18nPath.concat(friendlyURLPrivateUserPath);
                friendlyURLPublicPath = i18nPath.concat(friendlyURLPublicPath);
                mainPath = i18nPath.concat(mainPath);
            }
        }
        StringBundler sb = new StringBundler(6);
        sb.append(imagePath);
        sb.append("/company_logo");
        long companyLogoId = company.getLogoId();
        if (companyLogoId > 0L) {
            sb.append("?img_id=");
            sb.append(company.getLogoId());
            sb.append("&t=");
            sb.append(WebServerServletTokenUtil.getToken(company.getLogoId()));
        }
        String companyLogo = sb.toString();
        int companyLogoHeight = 0;
        int companyLogoWidth = 0;
        Image companyLogoImage = null;
        companyLogoImage = companyLogoId > 0L ? ImageLocalServiceUtil.getCompanyLogo(companyLogoId) : ImageToolUtil.getDefaultCompanyLogo();
        if (companyLogoImage != null) {
            companyLogoHeight = companyLogoImage.getHeight();
            companyLogoWidth = companyLogoImage.getWidth();
        }
        User user = null;
        try {
            user = PortalUtil.initUser(httpServletRequest);
        }
        catch (NoSuchUserException nsue) {
            if (_log.isDebugEnabled()) {
                _log.debug(nsue, nsue);
            }
            return null;
        }
        boolean bl = signedIn = !user.isDefaultUser();
        if (PropsValues.BROWSER_CACHE_DISABLED || PropsValues.BROWSER_CACHE_SIGNED_IN_DISABLED && signedIn) {
            httpServletResponse.setDateHeader("Expires", 0L);
            httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            httpServletResponse.setHeader("Pragma", "no-cache");
        }
        User realUser = user;
        Long realUserId = (Long)session.getAttribute("USER_ID");
        if (realUserId != null && user.getUserId() != realUserId.longValue()) {
            realUser = UserLocalServiceUtil.getUserById(realUserId);
        }
        String doAsUserId = ParamUtil.getString(httpServletRequest, "doAsUserId");
        String doAsUserLanguageId = ParamUtil.getString(httpServletRequest, "doAsUserLanguageId");
        long doAsGroupId = ParamUtil.getLong(httpServletRequest, "doAsGroupId");
        long refererGroupId = ParamUtil.getLong(httpServletRequest, "refererGroupId");
        long refererPlid = ParamUtil.getLong(httpServletRequest, "refererPlid");
        if (refererPlid != 0L && LayoutLocalServiceUtil.fetchLayout(refererPlid) == null) {
            refererPlid = 0L;
        }
        if ((permissionChecker = PermissionThreadLocal.getPermissionChecker()) == null || permissionChecker.getUserId() != user.getUserId()) {
            permissionChecker = PermissionCheckerFactoryUtil.create(user);
            PermissionThreadLocal.setPermissionChecker(permissionChecker);
        }
        try {
            CookieKeys.validateSupportCookie(httpServletRequest);
        }
        catch (Exception e) {
            CookieKeys.addSupportCookie(httpServletRequest, httpServletResponse);
        }
        TimeZone timeZone = user.getTimeZone();
        if (timeZone == null) {
            timeZone = company.getTimeZone();
        }
        if (signedIn) {
            this._updateUserLayouts(user);
        }
        Layout layout = null;
        List<Layout> layouts = null;
        long plid = ParamUtil.getLong(httpServletRequest, "p_l_id");
        boolean viewableSourceGroup = true;
        if (plid > 0L) {
            layout = LayoutLocalServiceUtil.getLayout(plid);
        } else {
            long groupId = ParamUtil.getLong(httpServletRequest, "groupId");
            long layoutId = ParamUtil.getLong(httpServletRequest, "layoutId");
            if (groupId > 0L && layoutId > 0L) {
                boolean privateLayout = ParamUtil.getBoolean(httpServletRequest, "privateLayout");
                layout = LayoutLocalServiceUtil.getLayout(groupId, privateLayout, layoutId);
            }
        }
        if (layout != null && (layout.isPrivateLayout() && !PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || layout.isPublicLayout() && !PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) && (layoutGroup = layout.getGroup()).isUser()) {
            User layoutUser = UserLocalServiceUtil.getUserById(company.getCompanyId(), layoutGroup.getClassPK());
            this._updateUserLayouts(layoutUser);
            layout = LayoutLocalServiceUtil.fetchLayout(layout.getPlid());
        }
        if (layout != null && (sourceGroupId = ParamUtil.getLong(httpServletRequest, "p_v_l_s_g_id")) > 0L && sourceGroupId != layout.getGroupId()) {
            if (layout.isTypeControlPanel() || layout.isPublicLayout() || SitesUtil.isUserGroupLayoutSetViewable(permissionChecker, layout.getGroup())) {
                Group sourceGroup = GroupLocalServiceUtil.getGroup(sourceGroupId);
                layout = new VirtualLayout(layout, sourceGroup);
            } else {
                viewableSourceGroup = false;
            }
        }
        String ppid = ParamUtil.getString(httpServletRequest, "p_p_id");
        Boolean redirectToDefaultLayout = (Boolean)httpServletRequest.getAttribute("REDIRECT_TO_DEFAULT_LAYOUT");
        if (redirectToDefaultLayout == null) {
            redirectToDefaultLayout = Boolean.FALSE;
        }
        Group group = null;
        boolean loginRequest = this._isLoginRequest(httpServletRequest);
        boolean stagingGroup = false;
        boolean viewableGroup = false;
        if (layout != null) {
            group = layout.getGroup();
            stagingGroup = group.isStagingGroup();
            if (!signedIn && PropsValues.AUTH_FORWARD_BY_REDIRECT) {
                httpServletRequest.setAttribute("REQUESTED_LAYOUT", (Object)layout);
            }
            viewableGroup = this._hasAccessPermission(permissionChecker, layout, true);
            boolean viewableStaging = false;
            if (!group.isControlPanel() && GroupPermissionUtil.contains(permissionChecker, group, "VIEW_STAGING")) {
                viewableStaging = true;
            }
            if (viewableStaging) {
                layouts = LayoutLocalServiceUtil.getLayouts(layout.getGroupId(), layout.isPrivateLayout(), 0L);
            } else if (!(viewableGroup && viewableSourceGroup || !stagingGroup)) {
                layout = null;
            } else {
                if (!(loginRequest || viewableGroup && viewableSourceGroup && (redirectToDefaultLayout.booleanValue() || this._hasAccessPermission(permissionChecker, layout, false)))) {
                    if (user.isDefaultUser() && PropsValues.AUTH_LOGIN_PROMPT_ENABLED) {
                        throw new PrincipalException.MustBeAuthenticated(user.getUserId());
                    }
                    sb = new StringBundler(6);
                    sb.append("User ");
                    sb.append(user.getUserId());
                    sb.append(" is not allowed to access the ");
                    sb.append(layout.isPrivateLayout() ? "private" : "public");
                    sb.append(" pages of group ");
                    sb.append(layout.getGroupId());
                    if (_log.isWarnEnabled()) {
                        _log.warn(sb.toString());
                    }
                    throw new NoSuchLayoutException(sb.toString());
                }
                if (loginRequest && !viewableGroup) {
                    layout = null;
                } else if (group.isLayoutPrototype()) {
                    layouts = new ArrayList<Layout>();
                } else {
                    layouts = LayoutLocalServiceUtil.getLayouts(layout.getGroupId(), layout.isPrivateLayout(), 0L);
                    if (!group.isControlPanel()) {
                        doAsGroupId = 0L;
                    }
                }
            }
        }
        List<Layout> unfilteredLayouts = layouts;
        LayoutComposite viewableLayoutComposite = null;
        if (layout == null) {
            boolean ignoreHiddenLayouts = false;
            if ((!viewableGroup || !viewableSourceGroup) && stagingGroup || loginRequest && !viewableGroup) {
                ignoreHiddenLayouts = true;
            }
            viewableLayoutComposite = this._getDefaultViewableLayoutComposite(httpServletRequest, user, permissionChecker, signedIn, ignoreHiddenLayouts);
            httpServletRequest.setAttribute("LAYOUT_DEFAULT", (Object)Boolean.TRUE);
        } else {
            viewableLayoutComposite = this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, layout, layouts, false);
        }
        String layoutSetLogo = null;
        layout = viewableLayoutComposite.getLayout();
        layouts = viewableLayoutComposite.getLayouts();
        if (layout != null) {
            if (group == null) {
                group = layout.getGroup();
            }
            if (!group.isControlPanel()) {
                this._rememberVisitedGroupIds(httpServletRequest, group.getGroupId());
            }
        }
        LayoutTypePortlet layoutTypePortlet = null;
        layouts = this._mergeAdditionalLayouts(httpServletRequest, user, permissionChecker, layout, layouts);
        LayoutSet layoutSet = null;
        boolean hasUpdateLayoutPermission = false;
        if (layout != null) {
            String typeSettings;
            LayoutClone layoutClone;
            LayoutTypeAccessPolicy layoutTypeAccessPolicy = LayoutTypeAccessPolicyTracker.getLayoutTypeAccessPolicy(layout);
            boolean hasCustomizeLayoutPermission = layoutTypeAccessPolicy.isCustomizeLayoutAllowed(permissionChecker, layout);
            hasUpdateLayoutPermission = layoutTypeAccessPolicy.isUpdateLayoutAllowed(permissionChecker, layout);
            layoutSet = layout.getLayoutSet();
            if (company.isSiteLogo()) {
                long logoId = 0L;
                if (layoutSet.isLogo()) {
                    logoId = layoutSet.getLogoId();
                    if (logoId == 0L) {
                        logoId = layoutSet.getLiveLogoId();
                    }
                } else {
                    LayoutSet siblingLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet(layout.getGroupId(), !layout.isPrivateLayout());
                    if (siblingLayoutSet.isLogo()) {
                        logoId = siblingLayoutSet.getLogoId();
                    }
                }
                if (logoId > 0L) {
                    sb = new StringBundler(5);
                    sb.append(imagePath);
                    sb.append("/layout_set_logo?img_id=");
                    sb.append(logoId);
                    sb.append("&t=");
                    sb.append(WebServerServletTokenUtil.getToken(logoId));
                    layoutSetLogo = sb.toString();
                    Image layoutSetLogoImage = ImageLocalServiceUtil.getCompanyLogo(logoId);
                    companyLogo = layoutSetLogo;
                    companyLogoHeight = layoutSetLogoImage.getHeight();
                    companyLogoWidth = layoutSetLogoImage.getWidth();
                }
            }
            plid = layout.getPlid();
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            boolean customizable = layoutTypePortlet.isCustomizable();
            boolean customizedView = SessionParamUtil.getBoolean(httpServletRequest, "customized_view", true);
            if (!customizable || group.isLayoutPrototype() || group.isLayoutSetPrototype() || group.isStagingGroup()) {
                customizedView = false;
            }
            layoutTypePortlet.setCustomizedView(customizedView);
            layoutTypePortlet.setUpdatePermission(hasUpdateLayoutPermission);
            if (signedIn && customizable && customizedView && hasCustomizeLayoutPermission) {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(user.getUserId(), true);
                layoutTypePortlet.setPortalPreferences(portalPreferences);
            }
            if ((layoutClone = LayoutCloneFactory.getInstance()) != null && (typeSettings = layoutClone.get(httpServletRequest, plid)) != null) {
                UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
                typeSettingsProperties.load(typeSettings);
                String stateMax = typeSettingsProperties.getProperty("state-max");
                String stateMin = typeSettingsProperties.getProperty("state-min");
                String modeAbout = typeSettingsProperties.getProperty("mode-about");
                String modeConfig = typeSettingsProperties.getProperty("mode-config");
                String modeEdit = typeSettingsProperties.getProperty("mode-edit");
                String modeEditDefaults = typeSettingsProperties.getProperty("mode-edit-defaults");
                String modeEditGuest = typeSettingsProperties.getProperty("mode-edit-guest");
                String modeHelp = typeSettingsProperties.getProperty("mode-help");
                String modePreview = typeSettingsProperties.getProperty("mode-preview");
                String modePrint = typeSettingsProperties.getProperty("mode-print");
                layoutTypePortlet.setStateMax(stateMax);
                layoutTypePortlet.setStateMin(stateMin);
                layoutTypePortlet.setModeAbout(modeAbout);
                layoutTypePortlet.setModeConfig(modeConfig);
                layoutTypePortlet.setModeEdit(modeEdit);
                layoutTypePortlet.setModeEditDefaults(modeEditDefaults);
                layoutTypePortlet.setModeEditGuest(modeEditGuest);
                layoutTypePortlet.setModeHelp(modeHelp);
                layoutTypePortlet.setModePreview(modePreview);
                layoutTypePortlet.setModePrint(modePrint);
            }
            httpServletRequest.setAttribute("LAYOUT", (Object)layout);
            httpServletRequest.setAttribute("LAYOUTS", layouts);
        }
        String i18nLanguageId = (String)httpServletRequest.getAttribute("I18N_LANGUAGE_ID");
        Locale locale = PortalUtil.getLocale(httpServletRequest, httpServletResponse, true);
        long scopeGroupId = PortalUtil.getScopeGroupId(httpServletRequest);
        if (group.isInheritContent()) {
            scopeGroupId = group.getParentGroupId();
        }
        if (scopeGroupId <= 0L && doAsGroupId > 0L) {
            scopeGroupId = doAsGroupId;
        }
        long siteGroupId = 0L;
        if (layout != null) {
            siteGroupId = layout.isTypeControlPanel() ? PortalUtil.getSiteGroupId(scopeGroupId) : PortalUtil.getSiteGroupId(layout.getGroupId());
        }
        Theme theme = null;
        ColorScheme colorScheme = null;
        if (layout != null && (layout.isTypeControlPanel() || group.isControlPanel())) {
            String themeId = PrefsPropsUtil.getString(company.getCompanyId(), "control.panel.layout.regular.theme.id");
            String colorSchemeId = ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId();
            theme = ThemeLocalServiceUtil.getTheme(company.getCompanyId(), themeId);
            colorScheme = ThemeLocalServiceUtil.getColorScheme(company.getCompanyId(), theme.getThemeId(), colorSchemeId);
            httpServletRequest.setAttribute("COLOR_SCHEME", (Object)colorScheme);
            httpServletRequest.setAttribute("THEME", (Object)theme);
        }
        boolean themeCssFastLoad = PropsValues.THEME_CSS_FAST_LOAD;
        if (PropsValues.THEME_CSS_FAST_LOAD_CHECK_REQUEST_PARAMETER) {
            themeCssFastLoad = SessionParamUtil.getBoolean(httpServletRequest, "css_fast_load", PropsValues.THEME_CSS_FAST_LOAD);
        }
        boolean themeImagesFastLoad = PropsValues.THEME_IMAGES_FAST_LOAD;
        if (PropsValues.THEME_IMAGES_FAST_LOAD_CHECK_REQUEST_PARAMETER) {
            SessionParamUtil.getBoolean(httpServletRequest, "images_fast_load", PropsValues.THEME_IMAGES_FAST_LOAD);
        }
        if ((themeJsBarebone = PropsValues.JAVASCRIPT_BAREBONE_ENABLED) && (signedIn || PropsValues.JAVASCRIPT_SINGLE_PAGE_APPLICATION_ENABLED)) {
            themeJsBarebone = false;
        }
        boolean themeJsFastLoad = SessionParamUtil.getBoolean(httpServletRequest, "js_fast_load", PropsValues.JAVASCRIPT_FAST_LOAD);
        String lifecycle = ParamUtil.getString(httpServletRequest, "p_p_lifecycle", "0");
        lifecycle = ParamUtil.getString(httpServletRequest, "p_t_lifecycle", lifecycle);
        String async = ParamUtil.getString(httpServletRequest, "p_p_async");
        String hub = ParamUtil.getString(httpServletRequest, "p_p_hub");
        boolean isolated = ParamUtil.getBoolean(httpServletRequest, "p_p_isolated");
        boolean widget = false;
        Boolean widgetObj = (Boolean)httpServletRequest.getAttribute("WIDGET");
        if (widgetObj != null) {
            widget = widgetObj;
        }
        ThemeDisplay themeDisplay = ThemeDisplayFactory.create();
        themeDisplay.setRequest(httpServletRequest);
        themeDisplay.setResponse(httpServletResponse);
        boolean secure = PortalUtil.isForwardedSecure(httpServletRequest);
        themeDisplay.setCDNHost(cdnHost);
        themeDisplay.setCDNDynamicResourcesHost(dynamicResourcesCDNHost);
        themeDisplay.setPortalDomain(ServicePreAction._getPortalDomain(portalURL));
        themeDisplay.setPortalURL(portalURL);
        themeDisplay.setRefererPlid(refererPlid);
        themeDisplay.setSecure(secure);
        themeDisplay.setServerName(PortalUtil.getForwardedHost(httpServletRequest));
        themeDisplay.setServerPort(PortalUtil.getForwardedPort(httpServletRequest));
        themeDisplay.setWidget(widget);
        themeDisplay.setAsync(async.equals("1"));
        themeDisplay.setCompany(company);
        themeDisplay.setCompanyLogo(companyLogo);
        themeDisplay.setCompanyLogoHeight(companyLogoHeight);
        themeDisplay.setCompanyLogoWidth(companyLogoWidth);
        themeDisplay.setDoAsGroupId(doAsGroupId);
        themeDisplay.setDoAsUserId(doAsUserId);
        themeDisplay.setDoAsUserLanguageId(doAsUserLanguageId);
        themeDisplay.setHubAction(hub.equals("0"));
        themeDisplay.setHubPartialAction(hub.equals("1"));
        themeDisplay.setHubResource(hub.equals("2"));
        themeDisplay.setI18nLanguageId(i18nLanguageId);
        themeDisplay.setI18nPath(i18nPath);
        themeDisplay.setIsolated(isolated);
        themeDisplay.setLanguageId(LocaleUtil.toLanguageId(locale));
        themeDisplay.setLayout(layout);
        themeDisplay.setLayouts(layouts);
        themeDisplay.setLayoutSet(layoutSet);
        themeDisplay.setLayoutSetLogo(layoutSetLogo);
        themeDisplay.setLayoutTypePortlet(layoutTypePortlet);
        themeDisplay.setLifecycle(lifecycle);
        themeDisplay.setLifecycleAction(lifecycle.equals("1"));
        themeDisplay.setLifecycleEvent(lifecycle.equals("3"));
        themeDisplay.setLifecycleRender(lifecycle.equals("0"));
        themeDisplay.setLifecycleResource(lifecycle.equals("2"));
        themeDisplay.setLocale(locale);
        themeDisplay.setLookAndFeel(theme, colorScheme);
        themeDisplay.setPathApplet(contextPath.concat("/applets"));
        themeDisplay.setPathCms(contextPath.concat("/cms"));
        themeDisplay.setPathContext(contextPath);
        themeDisplay.setPathFlash(contextPath.concat("/flash"));
        themeDisplay.setPathFriendlyURLPrivateGroup(friendlyURLPrivateGroupPath);
        themeDisplay.setPathFriendlyURLPrivateUser(friendlyURLPrivateUserPath);
        themeDisplay.setPathFriendlyURLPublic(friendlyURLPublicPath);
        themeDisplay.setPathImage(imagePath);
        themeDisplay.setPathJavaScript(PortalWebResourcesUtil.getContextPath("js"));
        themeDisplay.setPathMain(mainPath);
        themeDisplay.setPathSound(contextPath.concat("/html/sound"));
        themeDisplay.setPermissionChecker(permissionChecker);
        themeDisplay.setPlid(plid);
        themeDisplay.setPpid(ppid);
        themeDisplay.setRealCompanyLogo(companyLogo);
        themeDisplay.setRealCompanyLogoHeight(companyLogoHeight);
        themeDisplay.setRealCompanyLogoWidth(companyLogoWidth);
        themeDisplay.setRealUser(realUser);
        themeDisplay.setRefererGroupId(refererGroupId);
        themeDisplay.setScopeGroupId(scopeGroupId);
        themeDisplay.setSignedIn(signedIn);
        themeDisplay.setSiteDefaultLocale(PortalUtil.getSiteDefaultLocale(siteGroupId));
        themeDisplay.setSiteGroupId(siteGroupId);
        themeDisplay.setStateExclusive(LiferayWindowState.isExclusive(httpServletRequest));
        themeDisplay.setStateMaximized(LiferayWindowState.isMaximized(httpServletRequest));
        themeDisplay.setStatePopUp(LiferayWindowState.isPopUp(httpServletRequest));
        themeDisplay.setThemeCssFastLoad(themeCssFastLoad);
        themeDisplay.setThemeImagesFastLoad(themeImagesFastLoad);
        themeDisplay.setThemeJsBarebone(themeJsBarebone);
        themeDisplay.setThemeJsFastLoad(themeJsFastLoad);
        themeDisplay.setTimeZone(timeZone);
        themeDisplay.setUnfilteredLayouts(unfilteredLayouts);
        themeDisplay.setUser(user);
        boolean showControlPanelIcon = false;
        if (signedIn && PortalPermissionUtil.contains(permissionChecker, "VIEW_CONTROL_PANEL")) {
            showControlPanelIcon = true;
        }
        themeDisplay.setShowControlPanelIcon(showControlPanelIcon);
        themeDisplay.setShowHomeIcon(true);
        themeDisplay.setShowMyAccountIcon(signedIn);
        themeDisplay.setShowPageSettingsIcon(hasUpdateLayoutPermission);
        themeDisplay.setShowPortalIcon(true);
        themeDisplay.setShowSignInIcon(!signedIn);
        boolean showSignOutIcon = signedIn;
        if (themeDisplay.isImpersonated()) {
            showSignOutIcon = false;
        }
        themeDisplay.setShowSignOutIcon(showSignOutIcon);
        themeDisplay.setShowStagingIcon(false);
        boolean showSiteAdministrationIcon = false;
        if (signedIn && GroupPermissionUtil.contains(permissionChecker, group, "VIEW_SITE_ADMINISTRATION")) {
            showSiteAdministrationIcon = true;
        }
        themeDisplay.setShowSiteAdministrationIcon(showSiteAdministrationIcon);
        if (PropsValues.SESSION_ENABLE_URL_WITH_SESSION_ID && !CookieKeys.hasSessionId(httpServletRequest)) {
            themeDisplay.setAddSessionIdToURL(true);
            themeDisplay.setSessionId(session.getId());
        }
        String urlControlPanel = friendlyURLPrivateGroupPath.concat("/control_panel");
        if (Validator.isNotNull(doAsUserId)) {
            urlControlPanel = HttpUtil.addParameter(urlControlPanel, "doAsUserId", doAsUserId);
        }
        if (refererGroupId > 0L) {
            urlControlPanel = HttpUtil.addParameter(urlControlPanel, "refererGroupId", refererGroupId);
        } else if (scopeGroupId > 0L && (refererLayout = LayoutLocalServiceUtil.fetchLayout(plid)) != null && (refererLayoutGroup = refererLayout.getGroup()).isUserGroup()) {
            urlControlPanel = HttpUtil.addParameter(urlControlPanel, "refererGroupId", scopeGroupId);
        }
        if (refererPlid > 0L) {
            urlControlPanel = HttpUtil.addParameter(urlControlPanel, "refererPlid", refererPlid);
        } else if (plid > 0L) {
            urlControlPanel = HttpUtil.addParameter(urlControlPanel, "refererPlid", plid);
        }
        if (themeDisplay.isAddSessionIdToURL()) {
            urlControlPanel = PortalUtil.getURLWithSessionId(urlControlPanel, session.getId());
        }
        themeDisplay.setURLControlPanel(urlControlPanel);
        String currentURL = PortalUtil.getCurrentURL(httpServletRequest);
        themeDisplay.setURLCurrent(currentURL);
        String urlHome = PortalUtil.getHomeURL(httpServletRequest);
        themeDisplay.setURLHome(urlHome);
        if (layout != null) {
            if (layout.isTypePortlet() && hasUpdateLayoutPermission) {
                themeDisplay.setShowLayoutTemplatesIcon(true);
                if (!group.isUser()) {
                    themeDisplay.setShowPageCustomizationIcon(true);
                }
            }
            if (hasUpdateLayoutPermission) {
                themeDisplay.setShowPageSettingsIcon(true);
            }
            if (group.hasStagingGroup()) {
                themeDisplay.setShowLayoutTemplatesIcon(false);
                themeDisplay.setURLPublishToLive(null);
            }
            if (group.isControlPanel()) {
                themeDisplay.setShowPageSettingsIcon(false);
                themeDisplay.setURLPublishToLive(null);
            }
            if (group.isStaged() || group.isStagingGroup()) {
                Group scopeGroup = GroupLocalServiceUtil.getGroup(scopeGroupId);
                boolean hasManageStagingPermission = GroupPermissionUtil.contains(permissionChecker, scopeGroup, "MANAGE_STAGING");
                boolean hasPublishStagingPermission = GroupPermissionUtil.contains(permissionChecker, scopeGroup, "PUBLISH_STAGING");
                boolean hasViewStagingPermission = GroupPermissionUtil.contains(permissionChecker, scopeGroup, "VIEW_STAGING");
                if (hasManageStagingPermission || hasPublishStagingPermission || hasUpdateLayoutPermission || hasViewStagingPermission) {
                    themeDisplay.setShowStagingIcon(true);
                }
                if (hasPublishStagingPermission) {
                    LiferayPortletURL publishToLiveURL = PortletURLFactoryUtil.create(httpServletRequest, "com_liferay_exportimport_web_portlet_ExportImportPortlet", plid, "RENDER_PHASE");
                    publishToLiveURL.setParameter("mvcRenderCommandName", "publishLayouts");
                    if (layout.isPrivateLayout()) {
                        publishToLiveURL.setParameter("tabs1", "private-pages");
                    } else {
                        publishToLiveURL.setParameter("tabs1", "public-pages");
                    }
                    publishToLiveURL.setParameter("groupId", String.valueOf(scopeGroupId));
                    publishToLiveURL.setParameter("selPlid", String.valueOf(plid));
                    publishToLiveURL.setPortletMode(PortletMode.VIEW);
                    publishToLiveURL.setWindowState(LiferayWindowState.EXCLUSIVE);
                    themeDisplay.setURLPublishToLive(publishToLiveURL);
                }
            }
        }
        if (!user.isActive() || PrefsPropsUtil.getBoolean(company.getCompanyId(), "terms.of.use.required") && !user.isAgreedToTermsOfUse()) {
            themeDisplay.setShowMyAccountIcon(false);
            themeDisplay.setShowPageSettingsIcon(false);
        }
        if (layout != null && layout.isLayoutPrototypeLinkActive()) {
            themeDisplay.setShowPageCustomizationIcon(false);
        }
        if (group.isLayoutPrototype()) {
            themeDisplay.setShowHomeIcon(false);
            themeDisplay.setShowMyAccountIcon(false);
            themeDisplay.setShowPageCustomizationIcon(false);
            themeDisplay.setShowPageSettingsIcon(true);
            themeDisplay.setShowPortalIcon(false);
            themeDisplay.setShowSignInIcon(false);
            themeDisplay.setShowSignOutIcon(false);
            themeDisplay.setShowSiteAdministrationIcon(false);
            themeDisplay.setShowStagingIcon(false);
        }
        if (group.isLayoutSetPrototype()) {
            themeDisplay.setShowPageCustomizationIcon(false);
        }
        if (group.hasStagingGroup()) {
            themeDisplay.setShowLayoutTemplatesIcon(false);
            themeDisplay.setShowPageCustomizationIcon(false);
        }
        themeDisplay.setURLPortal(portalURL.concat(contextPath));
        if (!secure && PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS) {
            secure = true;
        }
        String securePortalURL = PortalUtil.getPortalURL(httpServletRequest, secure);
        String urlSignIn = securePortalURL.concat(mainPath).concat(_PATH_PORTAL_LOGIN);
        if (layout != null) {
            urlSignIn = HttpUtil.addParameter(urlSignIn, "p_l_id", layout.getPlid());
        }
        themeDisplay.setURLSignIn(urlSignIn);
        themeDisplay.setURLSignOut(mainPath.concat(_PATH_PORTAL_LOGOUT));
        return themeDisplay;
    }

    private boolean _isLoginRequest(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        String mainPath = _PATH_MAIN;
        if (_PATH_PROXY != null) {
            if (!requestURI.startsWith(_PATH_PROXY)) {
                requestURI = _PATH_PROXY.concat(requestURI);
            }
            if (!mainPath.startsWith(_PATH_PROXY)) {
                mainPath = _PATH_PROXY.concat(mainPath);
            }
        }
        return requestURI.startsWith(mainPath) && requestURI.startsWith(_PATH_PORTAL_LOGIN, mainPath.length());
    }

    private List<Layout> _mergeAdditionalLayouts(HttpServletRequest httpServletRequest, User user, PermissionChecker permissionChecker, Layout layout, List<Layout> layouts) throws PortalException {
        Group guestGroup;
        if (layout == null || layout.isPrivateLayout()) {
            return layouts;
        }
        long layoutGroupId = layout.getGroupId();
        if (layoutGroupId != (guestGroup = GroupLocalServiceUtil.getGroup(user.getCompanyId(), "Guest")).getGroupId()) {
            Group layoutGroup = GroupLocalServiceUtil.getGroup(layoutGroupId);
            UnicodeProperties typeSettingsProperties = layoutGroup.getTypeSettingsProperties();
            boolean mergeGuestPublicPages = GetterUtil.getBoolean(typeSettingsProperties.getProperty("mergeGuestPublicPages"));
            if (!mergeGuestPublicPages) {
                return layouts;
            }
            List<Layout> guestLayouts = LayoutLocalServiceUtil.getLayouts(guestGroup.getGroupId(), false, 0L);
            LayoutComposite viewableLayoutComposite = this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, layout, guestLayouts, false);
            guestLayouts = viewableLayoutComposite.getLayouts();
            if (layouts == null) {
                return guestLayouts;
            }
            layouts.addAll(0, guestLayouts);
        } else {
            HttpSession session = httpServletRequest.getSession();
            Long previousGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS");
            if (previousGroupId != null && previousGroupId != layoutGroupId) {
                Group previousGroup = null;
                try {
                    previousGroup = GroupLocalServiceUtil.getGroup(previousGroupId);
                }
                catch (NoSuchGroupException nsge) {
                    if (_log.isWarnEnabled()) {
                        _log.warn(nsge, nsge);
                    }
                    return layouts;
                }
                UnicodeProperties typeSettingsProperties = previousGroup.getTypeSettingsProperties();
                boolean mergeGuestPublicPages = GetterUtil.getBoolean(typeSettingsProperties.getProperty("mergeGuestPublicPages"));
                if (!mergeGuestPublicPages) {
                    return layouts;
                }
                List<Layout> previousLayouts = LayoutLocalServiceUtil.getLayouts((long)previousGroupId, false, 0L);
                LayoutComposite viewableLayoutComposite = this._getViewableLayoutComposite(httpServletRequest, user, permissionChecker, layout, previousLayouts, false);
                if ((previousLayouts = viewableLayoutComposite.getLayouts()) != null) {
                    layouts.addAll(previousLayouts);
                }
            }
        }
        return layouts;
    }

    private void _rememberVisitedGroupIds(HttpServletRequest httpServletRequest, long currentGroupId) {
        String requestURI = GetterUtil.getString(httpServletRequest.getRequestURI());
        if (!requestURI.endsWith(_PATH_PORTAL_LAYOUT)) {
            return;
        }
        HttpSession session = httpServletRequest.getSession();
        Long recentGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT");
        Long previousGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS");
        if (recentGroupId == null) {
            recentGroupId = currentGroupId;
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT", (Object)recentGroupId);
        } else if (recentGroupId != currentGroupId) {
            previousGroupId = (long)recentGroupId;
            recentGroupId = currentGroupId;
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT", (Object)recentGroupId);
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS", (Object)previousGroupId);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Current group id " + currentGroupId);
            _log.debug("Recent group id " + recentGroupId);
            _log.debug("Previous group id " + previousGroupId);
        }
    }

    private void _servicePre(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = this._initThemeDisplay(httpServletRequest, httpServletResponse);
        if (themeDisplay == null) {
            return;
        }
        httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        ServiceContext serviceContext = ServiceContextFactory.getInstance(httpServletRequest);
        ServiceContextThreadLocal.pushServiceContext(serviceContext);
        if (PropsValues.LAYOUT_AJAX_RENDER_ENABLE) {
            boolean portletAjaxRender = ParamUtil.getBoolean(httpServletRequest, "p_p_ajax", true);
            httpServletRequest.setAttribute("PORTLET_AJAX_RENDER", (Object)portletAjaxRender);
        }
    }

    private void _updateUserLayouts(User user) throws Exception {
        Boolean hasPowerUserRole = null;
        boolean addDefaultUserPrivateLayouts = false;
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED && PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_AUTO_CREATE) {
            addDefaultUserPrivateLayouts = true;
            if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED) {
                if (hasPowerUserRole == null) {
                    hasPowerUserRole = this._hasPowerUserRole(user);
                }
                if (!hasPowerUserRole.booleanValue()) {
                    addDefaultUserPrivateLayouts = false;
                }
            }
        }
        Boolean hasPrivateLayouts = null;
        if (addDefaultUserPrivateLayouts && !(hasPrivateLayouts = Boolean.valueOf(LayoutLocalServiceUtil.hasLayouts(user, true, false))).booleanValue()) {
            this._addDefaultUserPrivateLayouts(user);
        }
        boolean deleteDefaultUserPrivateLayouts = false;
        if (!PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED) {
            deleteDefaultUserPrivateLayouts = true;
        } else if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED) {
            if (hasPowerUserRole == null) {
                hasPowerUserRole = this._hasPowerUserRole(user);
            }
            if (!hasPowerUserRole.booleanValue()) {
                deleteDefaultUserPrivateLayouts = true;
            }
        }
        if (deleteDefaultUserPrivateLayouts) {
            if (hasPrivateLayouts == null) {
                hasPrivateLayouts = LayoutLocalServiceUtil.hasLayouts(user, true, false);
            }
            if (hasPrivateLayouts.booleanValue()) {
                this._deleteDefaultUserPrivateLayouts(user);
            }
        }
        boolean addDefaultUserPublicLayouts = false;
        if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED && PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_AUTO_CREATE) {
            addDefaultUserPublicLayouts = true;
            if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED) {
                if (hasPowerUserRole == null) {
                    hasPowerUserRole = this._hasPowerUserRole(user);
                }
                if (!hasPowerUserRole.booleanValue()) {
                    addDefaultUserPublicLayouts = false;
                }
            }
        }
        Boolean hasPublicLayouts = null;
        if (addDefaultUserPublicLayouts && !(hasPublicLayouts = Boolean.valueOf(LayoutLocalServiceUtil.hasLayouts(user, false, false))).booleanValue()) {
            this._addDefaultUserPublicLayouts(user);
        }
        boolean deleteDefaultUserPublicLayouts = false;
        if (!PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            deleteDefaultUserPublicLayouts = true;
        } else if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED) {
            if (hasPowerUserRole == null) {
                hasPowerUserRole = this._hasPowerUserRole(user);
            }
            if (!hasPowerUserRole.booleanValue()) {
                deleteDefaultUserPublicLayouts = true;
            }
        }
        if (deleteDefaultUserPublicLayouts) {
            if (hasPublicLayouts == null) {
                hasPublicLayouts = LayoutLocalServiceUtil.hasLayouts(user, false, false);
            }
            if (hasPublicLayouts.booleanValue()) {
                this._deleteDefaultUserPublicLayouts(user);
            }
        }
    }

    static {
        _log = LogFactoryUtil.getLog(ServicePreAction.class);
        _portalDomains = new ConcurrentHashMap<String, String>();
        String pathProxy = PortalUtil.getPathProxy();
        _PATH_PROXY = Validator.isBlank(pathProxy) ? null : pathProxy;
    }

    protected class LayoutComposite {
        private final Layout _layout;
        private final List<Layout> _layouts;

        protected LayoutComposite(Layout layout, List<Layout> layouts) {
            this._layout = layout;
            this._layouts = layouts;
        }

        protected Layout getLayout() {
            return this._layout;
        }

        protected List<Layout> getLayouts() {
            return this._layouts;
        }
    }
}

