/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RandomLookAndFeelAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(RandomLookAndFeelAction.class);

    @Override
    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (!themeDisplay.isSignedIn()) {
                return;
            }
            String requestURI = GetterUtil.getString(httpServletRequest.getRequestURI());
            if (!requestURI.endsWith("/portal/layout")) {
                return;
            }
            Layout layout = themeDisplay.getLayout();
            if (layout == null) {
                return;
            }
            List<Theme> themes = ThemeLocalServiceUtil.getPageThemes(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId(), themeDisplay.getUserId());
            if (!themes.isEmpty()) {
                Theme theme = themes.get(RandomUtil.nextInt(themes.size()));
                List<ColorScheme> colorSchemes = theme.getColorSchemes();
                ColorScheme colorScheme = colorSchemes.get(RandomUtil.nextInt(colorSchemes.size()));
                LayoutServiceUtil.updateLookAndFeel(layout.getGroupId(), layout.isPrivateLayout(), layout.getPlid(), theme.getThemeId(), colorScheme.getColorSchemeId(), layout.getCss());
                themeDisplay.setLookAndFeel(theme, colorScheme);
                httpServletRequest.setAttribute("COLOR_SCHEME", (Object)colorScheme);
                httpServletRequest.setAttribute("THEME", (Object)theme);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new ActionException(e);
        }
    }
}

