/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RandomLayoutAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(RandomLayoutAction.class);

    @Override
    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (!themeDisplay.isSignedIn()) {
                return;
            }
            String requestURI = GetterUtil.getString(httpServletRequest.getRequestURI());
            if (!requestURI.endsWith("/portal/layout")) {
                return;
            }
            Layout layout = themeDisplay.getLayout();
            if (layout == null) {
                return;
            }
            Group generalGuestGroup = GroupLocalServiceUtil.getGroup(themeDisplay.getCompanyId(), "Guest");
            List<Layout> layouts = LayoutLocalServiceUtil.getLayouts(generalGuestGroup.getGroupId(), false);
            if (!layouts.isEmpty()) {
                Layout randomLayout = layouts.get(RandomUtil.nextInt(layouts.size()));
                themeDisplay.setLayout(randomLayout);
                themeDisplay.setLayoutTypePortlet((LayoutTypePortlet)randomLayout.getLayoutType());
                httpServletRequest.setAttribute("LAYOUT", (Object)randomLayout);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new ActionException(e);
        }
    }
}

