/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.deploy.RequiredPluginsUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployDir;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.javadoc.JavadocManagerUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.struts.AuthPublicPathRegistry;
import com.liferay.portal.util.BrowserLauncher;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

public class GlobalStartupAction
extends SimpleAction {
    private static final Log _log = LogFactoryUtil.getLog(GlobalStartupAction.class);
    private static List<AutoDeployListener> _autoDeployListeners;
    private static List<HotDeployListener> _hotDeployListeners;

    public static List<AutoDeployListener> getAutoDeployListeners(boolean reset) {
        String[] autoDeployListenerClassNames;
        if (_autoDeployListeners != null && !reset) {
            return _autoDeployListeners;
        }
        ArrayList<AutoDeployListener> autoDeployListeners = new ArrayList<AutoDeployListener>();
        for (String autoDeployListenerClassName : autoDeployListenerClassNames = PropsUtil.getArray("auto.deploy.listeners")) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug("Instantiating " + autoDeployListenerClassName);
                }
                AutoDeployListener autoDeployListener = (AutoDeployListener)InstanceFactory.newInstance(autoDeployListenerClassName);
                autoDeployListeners.add(autoDeployListener);
            }
            catch (Exception e) {
                _log.error("Unable to initialiaze auto deploy listener", e);
            }
        }
        _autoDeployListeners = autoDeployListeners;
        return _autoDeployListeners;
    }

    public static List<HotDeployListener> getHotDeployListeners() {
        String[] hotDeployListenerClassNames;
        if (_hotDeployListeners != null) {
            return _hotDeployListeners;
        }
        ArrayList<HotDeployListener> hotDeployListeners = new ArrayList<HotDeployListener>();
        for (String hotDeployListenerClassName : hotDeployListenerClassNames = PropsUtil.getArray("hot.deploy.listeners")) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug("Instantiating " + hotDeployListenerClassName);
                }
                HotDeployListener hotDeployListener = (HotDeployListener)InstanceFactory.newInstance(hotDeployListenerClassName);
                hotDeployListeners.add(hotDeployListener);
            }
            catch (Exception e) {
                _log.error("Unable to initialiaze hot deploy listener", e);
            }
        }
        _hotDeployListeners = hotDeployListeners;
        return _hotDeployListeners;
    }

    @Override
    public void run(String[] ids) {
        block14: {
            try {
                File deployDir = new File(PropsValues.AUTO_DEPLOY_DEPLOY_DIR);
                File destDir = new File(DeployUtil.getAutoDeployDestDir());
                long interval = PropsValues.AUTO_DEPLOY_INTERVAL;
                List<AutoDeployListener> autoDeployListeners = GlobalStartupAction.getAutoDeployListeners(false);
                AutoDeployDir autoDeployDir = new AutoDeployDir("defaultAutoDeployDir", deployDir, destDir, interval, autoDeployListeners);
                if (PropsValues.AUTO_DEPLOY_ENABLED) {
                    if (_log.isInfoEnabled()) {
                        _log.info("Registering auto deploy directories");
                    }
                    AutoDeployUtil.registerDir(autoDeployDir);
                } else if (_log.isInfoEnabled()) {
                    _log.info("Not registering auto deploy directories");
                }
            }
            catch (Exception e) {
                _log.error("Unable to register auto deploy directories", e);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Registering hot deploy listeners");
            }
            for (HotDeployListener hotDeployListener : GlobalStartupAction.getHotDeployListeners()) {
                HotDeployUtil.registerListener(hotDeployListener);
            }
            AuthPublicPathRegistry.register(PropsValues.AUTH_PUBLIC_PATHS);
            Thread currentThread = Thread.currentThread();
            JavadocManagerUtil.load("", currentThread.getContextClassLoader());
            try {
                InfrastructureUtil.getDataSource();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            try {
                if (!ServerDetector.isJOnAS()) {
                    InfrastructureUtil.getMailSession();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn(e.getMessage());
            }
        }
        ServletContext servletContext = ServletContextPool.get(PortalContextLoaderListener.getPortalServletContextName());
        JSONWebServiceActionsManagerUtil.registerServletContext(servletContext);
        PortalLifecycleUtil.register(new BasePortalLifecycle(){

            @Override
            protected void doPortalDestroy() {
            }

            @Override
            protected void doPortalInit() {
                RequiredPluginsUtil.startCheckingRequiredPlugins();
            }
        }, 2);
        if (Validator.isNotNull(PropsValues.BROWSER_LAUNCHER_URL)) {
            Thread browserLauncherThread = new Thread(new BrowserLauncher());
            browserLauncherThread.start();
        }
    }
}

