/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DefaultLandingPageAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(DefaultLandingPageAction.class);

    @Override
    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            this.doRun(httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            throw new ActionException(e);
        }
    }

    protected void doRun(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long companyId = PortalUtil.getCompanyId(httpServletRequest);
        String path = PrefsPropsUtil.getString(companyId, "default.landing.page.path");
        if (_log.isInfoEnabled()) {
            _log.info("default.landing.page.path=" + path);
        }
        if (Validator.isNull(path)) {
            return;
        }
        HttpSession session = httpServletRequest.getSession();
        if (path.contains("${liferay:screenName}") || path.contains("${liferay:userId}")) {
            User user = (User)session.getAttribute("USER");
            if (user == null) {
                return;
            }
            path = StringUtil.replace(path, new String[]{"${liferay:screenName}", "${liferay:userId}"}, new String[]{HtmlUtil.escapeURL(user.getScreenName()), String.valueOf(user.getUserId())});
        }
        LastPath lastPath = new LastPath("", path);
        session.setAttribute("LAST_PATH", (Object)lastPath);
    }
}

