/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.configuration;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.util.StringPlus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public abstract class BaseEditorProvider<T> {
    private final AtomicReference<List<EditorContributorProvider<T>>> _editorContributorsProviders = new AtomicReference();
    private final ServiceTracker<T, ?> _serviceTracker;

    public BaseEditorProvider(Class<T> editorContributorClass) {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(editorContributorClass, new EditorContributorServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void destroy() {
        this._serviceTracker.close();
    }

    protected void visitEditorContributors(Consumer<T> consumer, String portletName, String editorConfigKey, String editorName) {
        List<EditorContributorProvider<T>> editorContributorProviders = this._editorContributorsProviders.get();
        for (EditorContributorProvider<T> editorContributorProvider : editorContributorProviders) {
            if (!editorContributorProvider.matches(portletName, editorConfigKey, editorName)) continue;
            consumer.accept(editorContributorProvider.get());
        }
    }

    private class EditorContributorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<T, T> {
        private EditorContributorServiceTrackerCustomizer() {
        }

        @Override
        public T addingService(ServiceReference<T> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            Object editorOptionsContributor = registry.getService(serviceReference);
            List<String> portletNames = StringPlus.asList(serviceReference.getProperty("javax.portlet.name"));
            List<String> editorConfigKeys = StringPlus.asList(serviceReference.getProperty("editor.config.key"));
            List<String> editorNames = StringPlus.asList(serviceReference.getProperty("editor.name"));
            int serviceRanking = GetterUtil.getInteger(serviceReference.getProperty("service.ranking"));
            EditorContributorProvider editorContributorProvider = new EditorContributorProvider(editorOptionsContributor, portletNames, editorConfigKeys, editorNames, serviceRanking);
            BaseEditorProvider.this._editorContributorsProviders.updateAndGet(editorContributorProviders -> {
                int index = Collections.binarySearch(editorContributorProviders = editorContributorProviders == null ? new ArrayList<EditorContributorProvider>() : new ArrayList(editorContributorProviders), editorContributorProvider, Comparator.reverseOrder());
                if (index < 0) {
                    index = -index - 1;
                }
                editorContributorProviders.add(index, editorContributorProvider);
                return editorContributorProviders;
            });
            return editorOptionsContributor;
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, T editorOptionsContributor) {
            this.removedService(serviceReference, (T)editorOptionsContributor);
            this.addingService(serviceReference);
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, T editorContributor) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            BaseEditorProvider.this._editorContributorsProviders.updateAndGet(editorContributorProviders -> {
                editorContributorProviders = new ArrayList<EditorContributorProvider>((Collection<EditorContributorProvider>)editorContributorProviders);
                editorContributorProviders.removeIf(editorContributorProvider -> ((EditorContributorProvider)editorContributorProvider)._editorContributor == editorContributor);
                if (editorContributorProviders.isEmpty()) {
                    return null;
                }
                return editorContributorProviders;
            });
        }
    }

    private static class EditorContributorProvider<T>
    implements Comparable<EditorContributorProvider<T>> {
        private static final int[] _PRIORITIES = new int[]{7, 6, 4, 2, 5, 3, 1, 0};
        private final Set<String> _editorConfigKeys;
        private final T _editorContributor;
        private final Set<String> _editorNames;
        private final Set<String> _portletNames;
        private final int _priority;
        private final int _serviceRanking;

        @Override
        public int compareTo(EditorContributorProvider<T> editorContributorProvider) {
            int result = Integer.compare(this._priority, editorContributorProvider._priority);
            if (result == 0) {
                return Integer.compare(editorContributorProvider._serviceRanking, this._serviceRanking);
            }
            return result;
        }

        public T get() {
            return this._editorContributor;
        }

        public boolean matches(String portletName, String editorConfigKey, String editorName) {
            return this._matches(portletName, this._portletNames) && this._matches(editorConfigKey, this._editorConfigKeys) && this._matches(editorName, this._editorNames);
        }

        private EditorContributorProvider(T editorContributor, List<String> portletNames, List<String> editorConfigKeys, List<String> editorNames, int serviceRanking) {
            this._editorContributor = editorContributor;
            this._portletNames = this._toSet(portletNames);
            this._editorConfigKeys = this._toSet(editorConfigKeys);
            this._editorNames = this._toSet(editorNames);
            this._serviceRanking = serviceRanking;
            this._priority = this._getPriority();
        }

        private int _getPriority() {
            int index = 0;
            if (!this._portletNames.isEmpty()) {
                index |= 4;
            }
            if (!this._editorConfigKeys.isEmpty()) {
                index |= 2;
            }
            if (!this._editorNames.isEmpty()) {
                index |= 1;
            }
            return _PRIORITIES[index];
        }

        private boolean _matches(String name, Set<String> names) {
            return names.isEmpty() || names.contains(name);
        }

        private Set<String> _toSet(List<String> names) {
            if (names.isEmpty()) {
                return Collections.emptySet();
            }
            return new HashSet<String>(names);
        }
    }
}

