/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.theme.ThemeLoaderFactory;
import javax.servlet.ServletContext;

public class ThemeLoaderHotDeployListener
extends BaseHotDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(ThemeLoaderHotDeployListener.class);

    @Override
    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering theme loader for ", t);
        }
    }

    @Override
    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering theme loader for ", t);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug("Invoking deploy for " + servletContextName);
        }
        if ((xmls = new String[]{HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-theme-loader.xml"))})[0] == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Registering theme loader for " + servletContextName);
        }
        ThemeLoaderFactory.init(servletContextName, servletContext, xmls);
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        boolean value;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug("Invoking undeploy for " + servletContextName);
        }
        if (!(value = ThemeLoaderFactory.destroy(servletContextName))) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Unregistering theme loader for " + servletContextName);
        }
        ServletContextPool.remove(servletContextName);
        if (_log.isInfoEnabled()) {
            _log.info("Theme loader for " + servletContextName + " unregistered successfully");
        }
    }
}

