/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.servlet.FileTimestampUtil;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class ThemeHotDeployListener
extends BaseHotDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(ThemeHotDeployListener.class);
    private static final Map<String, List<Theme>> _themes = new HashMap<String, List<Theme>>();

    @Override
    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering themes for ", t);
        }
    }

    @Override
    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering themes for ", t);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug("Invoking deploy for " + servletContextName);
        }
        if ((xmls = new String[]{HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-look-and-feel.xml"))})[0] == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Registering themes for " + servletContextName);
        }
        FileTimestampUtil.reset(servletContext);
        List<Theme> themes = ThemeLocalServiceUtil.init(servletContextName, servletContext, null, true, xmls, hotDeployEvent.getPluginPackage());
        _themes.put(servletContextName, themes);
        servletContext.setAttribute("PLUGIN_THEMES", themes);
        if (_log.isInfoEnabled()) {
            if (themes.size() == 1) {
                _log.info("1 theme for " + servletContextName + " is available for use");
            } else {
                _log.info(StringBundler.concat(themes.size(), " themes for ", servletContextName, " are available for use"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        List<Theme> themes;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug("Invoking undeploy for " + servletContextName);
        }
        if ((themes = _themes.remove(servletContextName)) != null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Unregistering themes for " + servletContextName);
            }
            try {
                ThemeLocalServiceUtil.uninstallThemes(themes);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        } else {
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            TemplateResourceLoaderUtil.clearCache("ftl");
            TemplateResourceLoaderUtil.clearCache("vm");
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
        if (_log.isInfoEnabled()) {
            if (themes.size() == 1) {
                _log.info("1 theme for " + servletContextName + " was unregistered");
            } else {
                _log.info(StringBundler.concat(themes.size(), " themes for ", servletContextName, " were unregistered"));
            }
        }
    }
}

