/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.javadoc.JavadocManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.portlet.CustomUserAttributes;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.FileTimestampUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.ServletContext;

public class PortletHotDeployListener
extends BaseHotDeployListener {
    private static final String _JNDI_JDBC = "java_liferay:jdbc";
    private static final String _JNDI_JDBC_LIFERAY_POOL = "java_liferay:jdbc/LiferayPool";
    private static final Log _log = LogFactoryUtil.getLog(PortletHotDeployListener.class);
    private static final Map<String, Boolean> _dataSourceBindStates = new HashMap<String, Boolean>();
    private static final Map<String, List<Portlet>> _portlets = new HashMap<String, List<Portlet>>();
    private final Map<String, ServiceRegistration<ResourceBundleLoader>> _resourceBundleLoaderServiceRegistrations = new HashMap<String, ServiceRegistration<ResourceBundleLoader>>();

    @Override
    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering portlets for ", t);
        }
    }

    @Override
    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering portlets for ", t);
        }
    }

    protected void checkResourceBundles(ClassLoader classLoader, Portlet portlet) {
        if (Validator.isNull(portlet.getResourceBundle())) {
            return;
        }
        Registry registry = RegistryUtil.getRegistry();
        ResourceBundleLoader resourceBundleLoader = ResourceBundleUtil.getResourceBundleLoader(portlet.getResourceBundle(), classLoader);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("resource.bundle.base.name", portlet.getResourceBundle());
        properties.put("service.ranking", Integer.MIN_VALUE);
        properties.put("servlet.context.name", portlet.getContextName());
        this._resourceBundleLoaderServiceRegistrations.put(portlet.getPortletId(), registry.registerService(ResourceBundleLoader.class, resourceBundleLoader, properties));
    }

    @Deprecated
    protected void destroyPortlet(Portlet portlet, Set<String> portletIds) throws Exception {
        this._destroyPortlet(portlet, portletIds);
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        List beanFilterNames = (List)servletContext.getAttribute("BEAN_FILTER_NAMES");
        List beanPortletIds = (List)servletContext.getAttribute("BEAN_PORTLET_IDS");
        if (beanFilterNames != null || beanPortletIds != null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Detected bean portlet from servlet context attributes");
            }
            return;
        }
        try (InputStream inputStream = servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");){
            Manifest manifest;
            Attributes mainAttributes;
            String value;
            if (inputStream != null && (value = (mainAttributes = (manifest = new Manifest(inputStream)).getMainAttributes()).getValue("Require-Capability")) != null && value.contains("osgi.cdi.extension")) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Detected bean portlet from /META-INF/MANIFEST.MF");
                }
                return;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug("Invoking deploy for " + servletContextName);
        }
        if ((xmls = new String[]{HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/portlet.xml")), HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/portlet-custom.xml")), HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-portlet.xml")), HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/web.xml"))})[0] == null && xmls[1] == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Registering portlets for " + servletContextName);
        }
        PortletContextBag portletContextBag = new PortletContextBag(servletContextName);
        PortletContextBagPool.put(servletContextName, portletContextBag);
        List<Portlet> portlets = PortletLocalServiceUtil.initWAR(servletContextName, servletContext, xmls, hotDeployEvent.getPluginPackage());
        boolean portletAppInitialized = false;
        ClassLoader classLoader = hotDeployEvent.getContextClassLoader();
        for (Portlet portlet : portlets) {
            if (portletAppInitialized) continue;
            this.initPortletApp(servletContextName, servletContext, classLoader, portlet);
            portletAppInitialized = true;
        }
        String xml = HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-display.xml"));
        PortletCategory newPortletCategory = PortletLocalServiceUtil.getWARDisplay(servletContextName, xml);
        long[] companyIds = PortalInstances.getCompanyIds();
        for (long companyId : companyIds) {
            PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
            if (portletCategory != null) {
                portletCategory.merge(newPortletCategory);
                continue;
            }
            _log.error("Unable to register portlet for company " + companyId + " because it does not exist");
        }
        this.processPortletProperties(servletContextName, classLoader);
        Object object = portlets.iterator();
        while (object.hasNext()) {
            Portlet portlet = (Portlet)object.next();
            ResourceActionsUtil.check(portlet.getPortletId());
            this.checkResourceBundles(classLoader, portlet);
            for (long companyId : companyIds) {
                Portlet curPortlet = PortletLocalServiceUtil.getPortletById(companyId, portlet.getPortletId());
                PortletLocalServiceUtil.checkPortlet(curPortlet);
            }
        }
        for (Portlet portlet : portlets) {
            boolean ready = GetterUtil.getBoolean(servletContext.getInitParameter("portlets-ready-by-default"), true);
            portlet.setReady(ready);
        }
        JavadocManagerUtil.load(servletContextName, classLoader);
        DirectServletRegistryUtil.clearServlets();
        FileTimestampUtil.reset(servletContext);
        _portlets.put(servletContextName, portlets);
        servletContext.setAttribute("PLUGIN_PORTLETS", portlets);
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info("1 portlet for " + servletContextName + " is available for use");
            } else {
                _log.info(StringBundler.concat(portlets.size(), " portlets for ", servletContextName, " are available for use"));
            }
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        List<Portlet> portlets;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug("Invoking undeploy for " + servletContextName);
        }
        if ((portlets = _portlets.remove(servletContextName)) == null) {
            List beanPortletIds;
            List beanFilterNames = (List)servletContext.getAttribute("BEAN_FILTER_NAMES");
            if (beanFilterNames != null && _log.isInfoEnabled()) {
                if (beanFilterNames.size() == 1) {
                    _log.info("1 bean filter for " + servletContextName + " was unregistered");
                } else {
                    _log.info(StringBundler.concat(beanFilterNames.size(), " bean filters for ", servletContextName, " were unregistered"));
                }
            }
            if ((beanPortletIds = (List)servletContext.getAttribute("BEAN_PORTLET_IDS")) != null && _log.isInfoEnabled()) {
                if (beanPortletIds.size() == 1) {
                    _log.info("1 bean portlet for " + servletContextName + " was unregistered");
                } else {
                    _log.info(StringBundler.concat(beanPortletIds.size(), " bean portlets for ", servletContextName, " were unregistered"));
                }
            }
            return;
        }
        HashSet<String> portletIds = new HashSet<String>();
        if (_log.isDebugEnabled()) {
            _log.debug("Unregistering portlets for " + servletContextName);
        }
        for (Portlet portlet : portlets) {
            this._destroyPortlet(portlet, portletIds);
        }
        ServletContextPool.remove(servletContextName);
        if (!portletIds.isEmpty()) {
            long[] companyIds;
            for (long companyId : companyIds = PortalInstances.getCompanyIds()) {
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
                portletCategory.separate(portletIds);
            }
        }
        PortletContextBagPool.remove(servletContextName);
        JavadocManagerUtil.unload(servletContextName);
        DirectServletRegistryUtil.clearServlets();
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info("1 portlet for " + servletContextName + " was unregistered");
            } else {
                _log.info(StringBundler.concat(portlets.size(), " portlets for ", servletContextName, " were unregistered"));
            }
        }
    }

    protected void initPortletApp(String servletContextName, ServletContext servletContext, ClassLoader classLoader, Portlet portlet) throws Exception {
        PortletContextBag portletContextBag = PortletContextBagPool.get(servletContextName);
        PortletApp portletApp = portlet.getPortletApp();
        servletContext.setAttribute("com.liferay.portal.kernel.model.PortletApp", (Object)portletApp);
        Map<String, String> customUserAttributes = portletApp.getCustomUserAttributes();
        for (Map.Entry<String, String> entry : customUserAttributes.entrySet()) {
            String attrCustomClass = entry.getValue();
            Class<?> clazz = classLoader.loadClass(attrCustomClass);
            CustomUserAttributes customUserAttributesInstance = (CustomUserAttributes)clazz.newInstance();
            Map<String, CustomUserAttributes> customUserAttributesMap = portletContextBag.getCustomUserAttributes();
            customUserAttributesMap.put(attrCustomClass, customUserAttributesInstance);
        }
        Set<PortletFilter> portletFilters = portletApp.getPortletFilters();
        for (PortletFilter portletFilter : portletFilters) {
            javax.portlet.filter.PortletFilter portletFilterInstance = (javax.portlet.filter.PortletFilter)this.newInstance(classLoader, new Class[]{ActionFilter.class, EventFilter.class, javax.portlet.filter.PortletFilter.class, RenderFilter.class, ResourceFilter.class}, portletFilter.getFilterClass());
            Map<String, javax.portlet.filter.PortletFilter> portletFiltersMap = portletContextBag.getPortletFilters();
            portletFiltersMap.put(portletFilter.getFilterName(), portletFilterInstance);
        }
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create(portlet, servletContext);
        invokerPortlet.setPortletFilters();
        Set<PortletURLListener> portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLGenerationListener portletURLListenerInstance = (PortletURLGenerationListener)this.newInstance(classLoader, PortletURLGenerationListener.class, portletURLListener.getListenerClass());
            Map<String, PortletURLGenerationListener> portletURLListenersMap = portletContextBag.getPortletURLListeners();
            portletURLListenersMap.put(portletURLListener.getListenerClass(), portletURLListenerInstance);
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    protected void processPortletProperties(String servletContextName, ClassLoader classLoader) throws Exception {
        Configuration portletPropertiesConfiguration = null;
        try {
            portletPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration(classLoader, "portlet");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug("Unable to read portlet.properties");
            }
            return;
        }
        Properties portletProperties = portletPropertiesConfiguration.getProperties();
        if (portletProperties.isEmpty()) {
            return;
        }
        ResourceActionsUtil.read(servletContextName, classLoader, StringUtil.split(portletProperties.getProperty("resource.actions.configs")));
    }

    protected void unbindDataSource(String servletContextName) {
        block8: {
            Boolean dataSourceBindState = _dataSourceBindStates.remove(servletContextName);
            if (dataSourceBindState == null) {
                return;
            }
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug("Dynamically unbinding the Liferay data source");
                }
                InitialContext context = new InitialContext();
                try {
                    context.lookup(_JNDI_JDBC_LIFERAY_POOL);
                    context.unbind(_JNDI_JDBC_LIFERAY_POOL);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                try {
                    context.lookup(_JNDI_JDBC);
                    context.destroySubcontext(_JNDI_JDBC);
                }
                catch (NamingException namingException) {}
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn("Unable to dynamically unbind the Liferay data source: " + e.getMessage());
            }
        }
    }

    private void _destroyPortlet(Portlet portlet, Set<String> portletIds) throws Exception {
        portlet.unsetReady();
        PortletApp portletApp = portlet.getPortletApp();
        Set<PortletFilter> portletFilters = portletApp.getPortletFilters();
        for (PortletFilter portletFilter : portletFilters) {
            PortletFilterFactory.destroy(portletFilter);
        }
        Set<PortletURLListener> portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.destroy(portletURLListener);
        }
        PortletInstanceFactoryUtil.destroy(portlet);
        portletIds.add(portlet.getPortletId());
        ServiceRegistration<ResourceBundleLoader> serviceRegistration = this._resourceBundleLoaderServiceRegistrations.remove(portlet.getPortletId());
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }
}

