/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import javax.servlet.ServletContext;

public class MessagingHotDeployListener
extends BaseHotDeployListener {
    @Override
    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error sending deploy message for ", t);
        }
    }

    @Override
    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error sending undeploy message for ", t);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        Message message = new Message();
        message.put("command", "deploy");
        message.put("servletContextName", servletContextName);
        MessageBusUtil.sendMessage("liferay/hot_deploy", message);
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        Message message = new Message();
        message.put("command", "undeploy");
        message.put("servletContextName", servletContextName);
        MessageBusUtil.sendMessage("liferay/hot_deploy", message);
    }
}

