/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.deploy.RequiredPluginsUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeploy;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.url.URLContainer;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletContext;

public class HotDeployImpl
implements HotDeploy {
    private static final Log _log = LogFactoryUtil.getLog(HotDeployImpl.class);
    private boolean _capturePrematureEvents = true;
    private final Queue<HotDeployEvent> _dependentHotDeployEvents;
    private final Set<String> _deployedServletContextNames;
    private final List<HotDeployListener> _hotDeployListeners;

    public HotDeployImpl() {
        if (_log.isDebugEnabled()) {
            _log.debug("Initializing hot deploy manager " + this.hashCode());
        }
        this._dependentHotDeployEvents = new ConcurrentLinkedQueue<HotDeployEvent>();
        this._deployedServletContextNames = new HashSet<String>();
        this._hotDeployListeners = new ArrayList<HotDeployListener>();
    }

    @Override
    public synchronized void fireDeployEvent(final HotDeployEvent hotDeployEvent) {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        ServletContextPool.put(servletContext.getServletContextName(), servletContext);
        if (this._capturePrematureEvents) {
            BasePortalLifecycle portalLifecycle = new BasePortalLifecycle(){

                @Override
                protected void doPortalDestroy() {
                }

                @Override
                protected void doPortalInit() {
                    HotDeployImpl.this.fireDeployEvent(hotDeployEvent);
                }
            };
            PortalLifecycleUtil.register(portalLifecycle, 2);
        } else {
            this.doFireDeployEvent(hotDeployEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void fireUndeployEvent(HotDeployEvent hotDeployEvent) {
        for (int i = this._hotDeployListeners.size() - 1; i >= 0; --i) {
            HotDeployListener hotDeployListener = this._hotDeployListeners.get(i);
            PortletClassLoaderUtil.setServletContextName(hotDeployEvent.getServletContextName());
            try {
                hotDeployListener.invokeUndeploy(hotDeployEvent);
                continue;
            }
            catch (HotDeployException hde) {
                _log.error(hde, hde);
                continue;
            }
            finally {
                PortletClassLoaderUtil.setServletContextName(null);
            }
        }
        this._deployedServletContextNames.remove(hotDeployEvent.getServletContextName());
        ClassLoader classLoader = hotDeployEvent.getContextClassLoader();
        TemplateManagerUtil.destroy(classLoader);
        RequiredPluginsUtil.startCheckingRequiredPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerDependentPortalLifecycle(String servletContextName, PortalLifecycle portalLifecycle) {
        for (HotDeployEvent hotDeployEvent : this._dependentHotDeployEvents) {
            if (!Objects.equals(servletContextName, hotDeployEvent.getServletContextName())) continue;
            HotDeployImpl hotDeployImpl = this;
            synchronized (hotDeployImpl) {
                hotDeployEvent.addPortalLifecycle(portalLifecycle);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void registerListener(HotDeployListener hotDeployListener) {
        this._hotDeployListeners.add(hotDeployListener);
    }

    @Override
    public synchronized void reset() {
        this._capturePrematureEvents = true;
        this._dependentHotDeployEvents.clear();
        this._deployedServletContextNames.clear();
        this._hotDeployListeners.clear();
    }

    @Override
    public synchronized void setCapturePrematureEvents(boolean capturePrematureEvents) {
        this._capturePrematureEvents = capturePrematureEvents;
    }

    @Override
    public synchronized void unregisterListener(HotDeployListener hotDeployListener) {
        this._hotDeployListeners.remove(hotDeployListener);
    }

    @Override
    public synchronized void unregisterListeners() {
        this._hotDeployListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFireDeployEvent(HotDeployEvent hotDeployEvent) {
        String servletContextName = hotDeployEvent.getServletContextName();
        if (this._deployedServletContextNames.contains(servletContextName)) {
            return;
        }
        boolean hasDependencies = true;
        for (String dependentServletContextName : hotDeployEvent.getDependentServletContextNames()) {
            if (this._deployedServletContextNames.contains(dependentServletContextName)) continue;
            hasDependencies = false;
            break;
        }
        if (hasDependencies) {
            if (_log.isDebugEnabled()) {
                _log.debug("Deploying " + servletContextName + " from queue");
            }
            for (int i = 0; i < this._hotDeployListeners.size(); ++i) {
                HotDeployListener hotDeployListener = this._hotDeployListeners.get(i);
                PortletClassLoaderUtil.setServletContextName(hotDeployEvent.getServletContextName());
                try {
                    hotDeployListener.invokeDeploy(hotDeployEvent);
                    continue;
                }
                catch (HotDeployException hde) {
                    _log.error(hde, hde);
                    continue;
                }
                finally {
                    PortletClassLoaderUtil.setServletContextName(null);
                }
            }
            this._deployedServletContextNames.add(servletContextName);
            this._dependentHotDeployEvents.remove(hotDeployEvent);
            ClassLoader contextClassLoader = this.getContextClassLoader();
            try {
                this.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
                ArrayList<HotDeployEvent> dependentEvents = new ArrayList<HotDeployEvent>(this._dependentHotDeployEvents);
                for (HotDeployEvent dependentEvent : dependentEvents) {
                    this.setContextClassLoader(dependentEvent.getContextClassLoader());
                    this.doFireDeployEvent(dependentEvent);
                    if (this._dependentHotDeployEvents.contains(dependentEvent)) continue;
                    dependentEvent.flushInits();
                }
            }
            finally {
                this.setContextClassLoader(contextClassLoader);
            }
        } else if (!this._dependentHotDeployEvents.contains(hotDeployEvent)) {
            if (_log.isInfoEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("Queueing ");
                sb.append(servletContextName);
                sb.append(" for deploy because it is missing ");
                sb.append(this.getRequiredServletContextNames(hotDeployEvent));
                _log.info(sb.toString());
            }
            this._dependentHotDeployEvents.add(hotDeployEvent);
        } else if (_log.isInfoEnabled()) {
            for (HotDeployEvent dependentHotDeployEvent : this._dependentHotDeployEvents) {
                StringBundler sb = new StringBundler(3);
                sb.append(servletContextName);
                sb.append(" is still in queue because it is missing ");
                sb.append(this.getRequiredServletContextNames(dependentHotDeployEvent));
                _log.info(sb.toString());
            }
        }
    }

    protected ClassLoader getContextClassLoader() {
        Thread currentThread = Thread.currentThread();
        return currentThread.getContextClassLoader();
    }

    protected String getRequiredServletContextNames(HotDeployEvent hotDeployEvent) {
        ArrayList<String> requiredServletContextNames = new ArrayList<String>();
        for (String dependentServletContextName : hotDeployEvent.getDependentServletContextNames()) {
            if (this._deployedServletContextNames.contains(dependentServletContextName)) continue;
            requiredServletContextNames.add(dependentServletContextName);
        }
        Collections.sort(requiredServletContextNames);
        return StringUtil.merge(requiredServletContextNames, ", ");
    }

    protected void setContextClassLoader(ClassLoader contextClassLoader) {
        Thread currentThread = Thread.currentThread();
        currentThread.setContextClassLoader(contextClassLoader);
    }

    @Deprecated
    public static interface PACL {
        public void initPolicy(String var1, URLContainer var2, ClassLoader var3, Properties var4);

        public void unregister(ClassLoader var1);
    }
}

