/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.WebDirDetector;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.tools.WebXMLBuilder;
import com.liferay.portal.util.ExtRegistry;
import com.liferay.taglib.FileAvailabilityUtil;
import com.liferay.util.ant.CopyTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ExtHotDeployListener
extends BaseHotDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(ExtHotDeployListener.class);

    @Override
    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering extension environment for ", t);
        }
    }

    @Override
    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering extension environment for ", t);
        }
    }

    protected void copyJar(ServletContext servletContext, String dir, String jarName) throws Exception {
        String servletContextName = servletContext.getServletContextName();
        String jarFullName = StringBundler.concat("/WEB-INF/", jarName, "/", jarName, ".jar");
        InputStream is = servletContext.getResourceAsStream(jarFullName);
        if (is == null) {
            throw new HotDeployException(jarFullName + " does not exist");
        }
        String newJarFullName = StringBundler.concat(dir, "ext-", servletContextName, jarName.substring(3), ".jar");
        StreamUtil.transfer(is, new FileOutputStream(new File(newJarFullName)));
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String xml;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug("Invoking deploy for " + servletContextName);
        }
        if ((xml = HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/ext-" + servletContextName + ".xml"))) == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("Registering extension environment for " + servletContextName);
        }
        if (ExtRegistry.isRegistered(servletContextName)) {
            if (_log.isInfoEnabled()) {
                _log.info("Extension environment for " + servletContextName + " has been applied.");
            }
            return;
        }
        Map<String, Set<String>> conflicts = ExtRegistry.getConflicts(servletContext);
        if (!conflicts.isEmpty()) {
            StringBundler sb = new StringBundler();
            sb.append("Extension environment for ");
            sb.append(servletContextName);
            sb.append(" cannot be applied because of detected conflicts:");
            for (Map.Entry<String, Set<String>> entry : conflicts.entrySet()) {
                String conflictServletContextName = entry.getKey();
                Set<String> conflictFiles = entry.getValue();
                sb.append("\n\t");
                sb.append(conflictServletContextName);
                sb.append(":");
                for (String conflictFile : conflictFiles) {
                    sb.append("\n\t\t");
                    sb.append(conflictFile);
                }
            }
            _log.error(sb.toString());
            return;
        }
        this.installExt(servletContext, hotDeployEvent.getContextClassLoader());
        FileAvailabilityUtil.clearAvailabilities();
        if (_log.isInfoEnabled()) {
            _log.info(StringBundler.concat("Extension environment for ", servletContextName, " has been applied. You must reboot the server and ", "redeploy all other plugins."));
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String xml;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug("Invoking undeploy for " + servletContextName);
        }
        if ((xml = HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/ext-" + servletContextName + ".xml"))) == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("Extension environment for " + servletContextName + " will not be undeployed");
        }
    }

    @Deprecated
    protected void installExt(ServletContext servletContext) throws Exception {
        this.installExt(servletContext, servletContext.getClassLoader());
    }

    protected void installExt(ServletContext servletContext, ClassLoader portletClassLoader) throws Exception {
        String servletContextName = servletContext.getServletContextName();
        String globalLibDir = PortalUtil.getGlobalLibDir();
        String portalWebDir = PortalUtil.getPortalWebDir();
        String portalLibDir = PortalUtil.getPortalLibDir();
        String pluginWebDir = WebDirDetector.getRootDir(portletClassLoader);
        if (ServerDetector.isTomcat()) {
            portalLibDir = globalLibDir.concat("portal/");
            FileUtil.mkdirs(portalLibDir);
            globalLibDir = globalLibDir.concat("global/");
            FileUtil.mkdirs(globalLibDir);
        }
        this.copyJar(servletContext, globalLibDir, "ext-kernel");
        this.copyJar(servletContext, portalLibDir, "ext-impl");
        this.copyJar(servletContext, portalLibDir, "ext-util-bridges");
        this.copyJar(servletContext, portalLibDir, "ext-util-java");
        this.copyJar(servletContext, portalLibDir, "ext-util-taglib");
        this.mergeWebXml(portalWebDir, pluginWebDir);
        CopyTask.copyDirectory(pluginWebDir + "WEB-INF/ext-web/docroot", portalWebDir, "", "**/WEB-INF/web.xml", true, false);
        FileUtil.copyFile(StringBundler.concat(pluginWebDir, "WEB-INF/ext-", servletContextName, ".xml"), StringBundler.concat(portalWebDir, "WEB-INF/ext-", servletContextName, ".xml"));
        ExtRegistry.registerExt(servletContext);
    }

    protected void mergeWebXml(String portalWebDir, String pluginWebDir) throws IOException {
        if (!FileUtil.exists(pluginWebDir + "WEB-INF/ext-web/docroot/WEB-INF/web.xml")) {
            return;
        }
        Path tempDirPath = Files.createTempDirectory(Paths.get(SystemProperties.get("java.io.tmpdir"), new String[0]), null, new FileAttribute[0]);
        File tempDir = tempDirPath.toFile();
        WebXMLBuilder.mergeWebXML(portalWebDir + "WEB-INF/web.xml", pluginWebDir + "WEB-INF/ext-web/docroot/WEB-INF/web.xml", tempDir.getAbsolutePath() + "/web.xml");
        File portalWebXml = new File(portalWebDir + "WEB-INF/web.xml");
        File tmpWebXml = new File(tempDir + "/web.xml");
        tmpWebXml.setLastModified(portalWebXml.lastModified());
        CopyTask.copyFile(tmpWebXml, new File(portalWebDir + "WEB-INF"), true, true);
        FileUtil.deltree(tempDir);
    }
}

