/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployDir;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RequiredPluginsUtil {
    private static final Log _log = LogFactoryUtil.getLog(RequiredPluginsUtil.class);
    private static ScheduledExecutorService _scheduledExecutorService;

    public static synchronized void startCheckingRequiredPlugins() {
        if (_scheduledExecutorService != null) {
            return;
        }
        _scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(RequiredPluginsUtil.class.getName(), 5, null));
        _scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                RequiredPluginsUtil.checkRequiredPlugins();
            }
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    public static synchronized void stopCheckingRequiredPlugins() {
        RequiredPluginsUtil._unschedule(true);
    }

    protected static synchronized void checkRequiredPlugins() {
        List<String[]> levelsRequiredDeploymentContexts = DeployManagerUtil.getLevelsRequiredDeploymentContexts();
        List<String[]> levelsRequiredDeploymentWARFileNames = DeployManagerUtil.getLevelsRequiredDeploymentWARFileNames();
        boolean deployed = false;
        for (int i = 0; i < levelsRequiredDeploymentContexts.size(); ++i) {
            String[] levelRequiredDeploymentContexts = levelsRequiredDeploymentContexts.get(i);
            String[] levelRequiredDeploymentWARFileNames = levelsRequiredDeploymentWARFileNames.get(i);
            for (int j = 0; j < levelRequiredDeploymentContexts.length; ++j) {
                AutoDeployDir autoDeployDir;
                String levelRequiredDeploymentContext = levelRequiredDeploymentContexts[j];
                if (DeployManagerUtil.isDeployed(levelRequiredDeploymentContext)) continue;
                deployed = true;
                if (_log.isDebugEnabled()) {
                    String levelRequiredDeploymentWARFileName = levelRequiredDeploymentWARFileNames[j];
                    _log.debug("Automatically deploying the required plugin " + levelRequiredDeploymentWARFileName);
                }
                if ((autoDeployDir = AutoDeployUtil.getDir("defaultAutoDeployDir")) == null) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug("The autodeploy directory defaultAutoDeployDir is null");
                    continue;
                }
                ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(StringBundler.concat("com/liferay/portal/deploy/dependencies/plugins", i + 1, "/", levelRequiredDeploymentWARFileNames[j]));
                try {
                    StreamUtil.transfer(inputStream, new FileOutputStream(autoDeployDir.getDeployDir() + "/" + levelRequiredDeploymentWARFileNames[j]));
                    continue;
                }
                catch (IOException ioe) {
                    _log.error("Unable to write file", ioe);
                }
            }
        }
        if (!deployed) {
            RequiredPluginsUtil._unschedule(false);
        }
    }

    private static void _unschedule(boolean awaitTermination) {
        if (_scheduledExecutorService != null) {
            _scheduledExecutorService.shutdownNow();
            if (awaitTermination) {
                try {
                    _scheduledExecutorService.awaitTermination(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException ie) {
                    _log.error(ie, ie);
                }
            }
            _scheduledExecutorService = null;
        }
    }
}

