/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.ant.CopyTask;
import com.liferay.util.ant.DeleteTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class DeployUtil {
    private static final Log _log = LogFactoryUtil.getLog(DeployUtil.class);
    private static final DeployUtil _instance = new DeployUtil();

    public static void copyDependencyXml(String fileName, String targetDir, String targetFileName, Map<String, String> filterMap, boolean overwrite) throws Exception {
        File targetFile = new File(targetDir, targetFileName);
        if (!targetFile.exists()) {
            HashSet<Path> tempPaths = new HashSet<Path>();
            File file = new File(DeployUtil.getResourcePath(tempPaths, fileName));
            CopyTask.copyFile(file, new File(targetDir), targetFileName, filterMap, overwrite, true);
            for (Path tempPath : tempPaths) {
                DeployUtil.deletePath(tempPath);
            }
        }
    }

    public static void deletePath(Path tempPath) throws IOException {
        Files.walkFileTree(tempPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioe) throws IOException {
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(filePath);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String getAutoDeployDestDir() throws Exception {
        String destDir = PropsValues.AUTO_DEPLOY_DEST_DIR;
        if (Validator.isNull(destDir)) {
            destDir = DeployUtil.getAutoDeployServerDestDir();
        }
        FileUtil.mkdirs(destDir);
        return destDir;
    }

    public static String getAutoDeployServerDestDir() throws Exception {
        String destDir = null;
        String serverId = GetterUtil.getString(ServerDetector.getServerId());
        destDir = serverId.equals("tomcat") ? PropsValues.AUTO_DEPLOY_TOMCAT_DEST_DIR : PrefsPropsUtil.getString("auto.deploy." + serverId + ".dest.dir");
        if (Validator.isNull(destDir)) {
            destDir = PropsValues.AUTO_DEPLOY_DEFAULT_DEST_DIR;
        }
        destDir = StringUtil.replace(destDir, '\\', '/');
        return destDir;
    }

    public static String getResourcePath(Set<Path> tempPaths, String resource) throws Exception {
        return _instance._getResourcePath(tempPaths, resource);
    }

    @Deprecated
    public static String getResourcePath(String resource) throws Exception {
        return _instance._getResourcePath(new HashSet<Path>(), resource);
    }

    public static void redeployJetty(String context) throws Exception {
        String contextsDirName = DeployUtil._getJettyHome() + "/contexts";
        if (DeployUtil._isPortalContext(context)) {
            throw new UnsupportedOperationException("This method is meant for redeploying plugins, not the portal");
        }
        File contextXml = new File(contextsDirName, context + ".xml");
        if (contextXml.exists()) {
            FileUtils.touch((File)contextXml);
        } else {
            HashMap<String, String> filterMap = new HashMap<String, String>();
            filterMap.put("context", context);
            DeployUtil.copyDependencyXml("jetty-context-configure.xml", contextXml.getParent(), contextXml.getName(), filterMap, true);
        }
    }

    public static void redeployTomcat(String context) throws Exception {
        if (DeployUtil._isPortalContext(context)) {
            throw new UnsupportedOperationException("This method is meant for redeploying plugins, not the portal");
        }
        File webXml = new File(DeployUtil.getAutoDeployDestDir(), context + "/WEB-INF/web.xml");
        FileUtils.touch((File)webXml);
    }

    public static void undeploy(String appServerType, File deployDir) throws Exception {
        boolean undeployEnabled = PrefsPropsUtil.getBoolean("hot.undeploy.enabled", PropsValues.HOT_UNDEPLOY_ENABLED);
        if (!undeployEnabled) {
            return;
        }
        if (!(appServerType.equals("glassfish") || appServerType.equals("jboss") || appServerType.equals("jetty") || appServerType.equals("tomcat") || appServerType.equals("weblogic") || appServerType.equals("wildfly"))) {
            return;
        }
        if (!deployDir.exists()) {
            String deployDirPath = deployDir.getAbsolutePath();
            deployDirPath = StringUtil.endsWith(deployDirPath, ".war") ? deployDirPath.substring(0, deployDirPath.length() - 4) : deployDirPath.concat(".war");
            deployDir = new File(deployDirPath);
        }
        if (!deployDir.exists()) {
            return;
        }
        if (deployDir.isFile()) {
            FileUtil.delete(deployDir);
        } else {
            File webXml = new File(deployDir + "/WEB-INF/web.xml");
            if (!webXml.exists()) {
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info("Undeploy " + deployDir);
            }
            FileUtil.delete(deployDir + "/WEB-INF/web.xml");
            DeleteTask.deleteDirectory(deployDir);
        }
        if (appServerType.equals("jetty")) {
            FileUtil.delete(StringBundler.concat(DeployUtil._getJettyHome(), "/contexts/", deployDir.getName(), ".xml"));
        }
        if (appServerType.equals("jboss") || appServerType.equals("wildfly")) {
            File deployedFile = new File(deployDir.getParent(), deployDir.getName() + ".deployed");
            FileUtil.delete(deployedFile);
        }
        int undeployInterval = PrefsPropsUtil.getInteger("hot.undeploy.interval", PropsValues.HOT_UNDEPLOY_INTERVAL);
        if (_log.isInfoEnabled()) {
            _log.info("Wait " + undeployInterval + " ms to allow the plugin time to fully undeploy");
        }
        if (undeployInterval > 0) {
            Thread.sleep(undeployInterval);
        }
    }

    private static String _getJettyHome() {
        String jettyHome = System.getProperty("jetty.home");
        if (jettyHome == null) {
            jettyHome = PortalUtil.getGlobalLibDir() + "../../..";
        }
        return jettyHome;
    }

    private static boolean _isPortalContext(String context) {
        return Validator.isNull(context) || context.equals("/") || context.equals(PortalContextLoaderListener.getPortalServletContextPath());
    }

    private DeployUtil() {
    }

    private String _getResourcePath(Set<Path> tempDirPaths, String resource) throws IOException {
        Class<?> clazz = this.getClass();
        InputStream inputStream = clazz.getResourceAsStream("dependencies/" + resource);
        if (inputStream == null) {
            return null;
        }
        Path tempDirPath = Files.createTempDirectory(Paths.get(SystemProperties.get("java.io.tmpdir"), new String[0]), null, new FileAttribute[0]);
        tempDirPaths.add(tempDirPath);
        File file = new File(tempDirPath + "/liferay/com/liferay/portal/deploy/dependencies/" + resource);
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            FileUtil.mkdirs(parentFile);
        }
        StreamUtil.transfer(inputStream, new FileOutputStream(file));
        return FileUtil.getAbsolutePath(file);
    }
}

