/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.function.Function;
import java.util.regex.Matcher;

public class SybaseSQLTransformerLogic
extends BaseSQLTransformerLogic {
    public SybaseSQLTransformerLogic(DB db) {
        super(db);
        Function[] functions = new Function[]{this.getBitwiseCheckFunction(), this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getConcatFunction(), this.getDropTableIfExistsTextFunction(), this.getInstrFunction(), this.getIntegerDivisionFunction(), this.getLengthFunction(), this.getModFunction(), this.getNullDateFunction(), this.getSubstrFunction(), this._getCrossJoinFunction(), this._getReplaceFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = ArrayUtil.append(functions, this.getLowerFunction());
        }
        this.setFunctions(functions);
    }

    @Override
    protected String replaceCastLong(Matcher matcher) {
        return matcher.replaceAll("CONVERT(BIGINT, $1)");
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CAST($1 AS NVARCHAR(5461))");
    }

    private Function<String, String> _getCrossJoinFunction() {
        return sql -> StringUtil.replace(sql, "CROSS JOIN", ",");
    }

    private Function<String, String> _getReplaceFunction() {
        return sql -> sql.replaceAll("(?i)replace\\(", "str_replace(");
    }
}

