/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgreSQLTransformerLogic
extends BaseSQLTransformerLogic {
    private static final Pattern _negativeComparisonPattern = Pattern.compile("(!?=)\\s*(-([0-9]+)?)", 2);

    public PostgreSQLTransformerLogic(DB db) {
        super(db);
        Function[] functions = new Function[]{this.getBitwiseCheckFunction(), this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getDropTableIfExistsTextFunction(), this.getInstrFunction(), this.getIntegerDivisionFunction(), this._getNegativeComparisonFunction(), this._getNullDateFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = ArrayUtil.append(functions, this.getLowerFunction());
        }
        this.setFunctions(functions);
    }

    @Override
    protected String replaceCastLong(Matcher matcher) {
        return matcher.replaceAll("CAST($1 AS INTEGER)");
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CAST($1 AS TEXT)");
    }

    @Override
    protected String replaceInstr(Matcher matcher) {
        return matcher.replaceAll("POSITION($2 in $1)");
    }

    private Function<String, String> _getNegativeComparisonFunction() {
        return sql -> {
            Matcher matcher = _negativeComparisonPattern.matcher((CharSequence)sql);
            return matcher.replaceAll("$1 ($2)");
        };
    }

    private Function<String, String> _getNullDateFunction() {
        return sql -> StringUtil.replace(sql, "[$NULL_DATE$]", "CAST(NULL AS TIMESTAMP)");
    }
}

