/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.internal.dao.sql.transformer.SQLFunctionTransformer;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.function.Function;
import java.util.regex.Matcher;

public class OracleSQLTransformerLogic
extends BaseSQLTransformerLogic {
    public OracleSQLTransformerLogic(DB db) {
        super(db);
        Function[] functions = new Function[]{this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getConcatFunction(), this.getDropTableIfExistsTextFunction(), this.getIntegerDivisionFunction(), this.getNullDateFunction(), this._getEscapeFunction(), this._getNotEqualsBlankStringFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = ArrayUtil.append(functions, this.getLowerFunction());
        }
        this.setFunctions(functions);
    }

    @Override
    protected Function<String, String> getConcatFunction() {
        SQLFunctionTransformer sqlFunctionTransformer = new SQLFunctionTransformer("CONCAT(", "", " || ", "");
        return sqlFunctionTransformer::transform;
    }

    @Override
    protected String replaceCastClobText(Matcher matcher) {
        return matcher.replaceAll("DBMS_LOB.SUBSTR($1, 4000, 1)");
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CAST($1 AS VARCHAR(4000))");
    }

    @Override
    protected String replaceDropTableIfExistsText(Matcher matcher) {
        StringBundler sb = new StringBundler(9);
        sb.append("BEGIN\n");
        sb.append("EXECUTE IMMEDIATE 'DROP TABLE $1';\n");
        sb.append("EXCEPTION\n");
        sb.append("WHEN OTHERS THEN\n");
        sb.append("IF SQLCODE != -942 THEN\n");
        sb.append("RAISE;\n");
        sb.append("END IF;\n");
        sb.append("END;\n");
        sb.append("/");
        String dropTableIfExists = sb.toString();
        return matcher.replaceAll(dropTableIfExists);
    }

    @Override
    protected String replaceIntegerDivision(Matcher matcher) {
        return matcher.replaceAll("TRUNC($1 / $2)");
    }

    private Function<String, String> _getEscapeFunction() {
        return sql -> StringUtil.replace(sql, "LIKE ?", "LIKE ? ESCAPE '\\'");
    }

    private Function<String, String> _getNotEqualsBlankStringFunction() {
        return sql -> StringUtil.replace(sql, " != ''", " IS NOT NULL");
    }
}

