/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.function.Function;
import java.util.regex.Matcher;

public class HypersonicSQLTransformerLogic
extends BaseSQLTransformerLogic {
    public HypersonicSQLTransformerLogic(DB db) {
        super(db);
        Function[] functions = new Function[]{this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getDropTableIfExistsTextFunction(), this.getIntegerDivisionFunction(), this.getNullDateFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = ArrayUtil.append(functions, this.getLowerFunction());
        }
        this.setFunctions(functions);
    }

    @Override
    protected String replaceCastLong(Matcher matcher) {
        return matcher.replaceAll("CONVERT($1, SQL_BIGINT)");
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CONVERT($1, SQL_VARCHAR)");
    }

    @Override
    protected String replaceDropTableIfExistsText(Matcher matcher) {
        return matcher.replaceAll("DROP TABLE $1 IF EXISTS");
    }
}

