/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.function.Function;

public class HQLToJPQLTransformerLogic {
    private static final String _HQL_COMPOSITE_ID_MARKER = "\\.id\\.";
    private static final String _HQL_NOT_EQUALS = "!=";
    private static final String _JPQL_DOT_SEPARTOR = ".";
    private static final String _JPQL_NOT_EQUALS = "<>";

    public static final Function<String, String> getCompositeIdMarkerFunction() {
        return sql -> StringUtil.replace(sql, _HQL_COMPOSITE_ID_MARKER, _JPQL_DOT_SEPARTOR);
    }

    public static final Function<String, String> getNotEqualsFunction() {
        return sql -> StringUtil.replace(sql, _HQL_NOT_EQUALS, _JPQL_NOT_EQUALS);
    }

    public static Function<String, String> getPositionalParameterFunction() {
        return sql -> {
            if (sql.indexOf(63) == -1) {
                return sql;
            }
            StringBundler sb = new StringBundler();
            int i = 1;
            int from = 0;
            int to = 0;
            while ((to = sql.indexOf(63, from)) != -1) {
                sb.append(sql.substring(from, to));
                sb.append("?");
                sb.append(i++);
                from = to + 1;
            }
            sb.append(sql.substring(from));
            return sb.toString();
        };
    }
}

