/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.hibernate.SessionFactoryImpl;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.hibernate.PortletTransactionManager;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionExecutorThreadLocal;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class VerifySessionFactoryWrapper
implements SessionFactory {
    private static final Log _log = LogFactoryUtil.getLog(VerifySessionFactoryWrapper.class);
    private final SessionFactoryImpl _sessionFactoryImpl;

    public static SessionFactory createVerifySessionFactoryWrapper(SessionFactoryImpl sessionFactoryImpl) {
        if (PropsValues.SPRING_HIBERNATE_SESSION_FACTORY_VERIFY) {
            return new VerifySessionFactoryWrapper(sessionFactoryImpl);
        }
        return sessionFactoryImpl;
    }

    public VerifySessionFactoryWrapper(SessionFactoryImpl sessionFactoryImpl) {
        this._sessionFactoryImpl = sessionFactoryImpl;
    }

    @Override
    public void closeSession(Session session) throws ORMException {
        InvocationHandler invocationHandler;
        if (session == null) {
            return;
        }
        if (PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED && ProxyUtil.isProxyClass(session.getClass()) && (invocationHandler = ProxyUtil.getInvocationHandler(session)).getClass() == SessionInvocationHandler.class) {
            session.flush();
        }
        this._sessionFactoryImpl.closeSession(session);
    }

    @Override
    public Session getCurrentSession() throws ORMException {
        return this._sessionFactoryImpl.getCurrentSession();
    }

    @Override
    public Dialect getDialect() throws ORMException {
        return this._sessionFactoryImpl.getDialect();
    }

    @Override
    public Session openNewSession(Connection connection) throws ORMException {
        return this._sessionFactoryImpl.openNewSession(connection);
    }

    @Override
    public Session openSession() throws ORMException {
        if (!PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED || this._verify()) {
            return this._sessionFactoryImpl.openSession();
        }
        Session session = this._sessionFactoryImpl.openSession();
        return (Session)ProxyUtil.newProxyInstance(Session.class.getClassLoader(), new Class[]{Session.class}, new SessionInvocationHandler(session));
    }

    private void _logFailure(SessionFactoryImplementor currentSessionFactoryImplementor, SessionFactoryImplementor targetSessionFactoryImplementor) {
        StringBundler sb = new StringBundler(5);
        sb.append("Wrong current transaction manager, current session ");
        sb.append("factory classes metadata: ");
        sb.append(currentSessionFactoryImplementor.getAllClassMetadata());
        sb.append(", target session factory classes metadata: ");
        sb.append(targetSessionFactoryImplementor.getAllClassMetadata());
        _log.error("Failed session factory verification", new IllegalStateException(sb.toString()));
    }

    private boolean _verify() {
        TransactionExecutor transactionExecutor = TransactionExecutorThreadLocal.getCurrentTransactionExecutor();
        if (transactionExecutor == null) {
            throw new IllegalStateException("No current transaction executor");
        }
        PlatformTransactionManager platformTransactionManager = transactionExecutor.getPlatformTransactionManager();
        if (platformTransactionManager == null) {
            throw new IllegalStateException("No transaction manager for transaction executor: " + transactionExecutor);
        }
        SessionFactoryImplementor targetSessionFactoryImplementor = this._sessionFactoryImpl.getSessionFactoryImplementor();
        if (platformTransactionManager instanceof HibernateTransactionManager) {
            HibernateTransactionManager hibernateTransactionManager = (HibernateTransactionManager)platformTransactionManager;
            SessionFactoryImplementor currentSessionFactoryImplementor = (SessionFactoryImplementor)hibernateTransactionManager.getSessionFactory();
            if (targetSessionFactoryImplementor == currentSessionFactoryImplementor) {
                return true;
            }
            this._logFailure(currentSessionFactoryImplementor, targetSessionFactoryImplementor);
            return false;
        }
        if (platformTransactionManager instanceof PortletTransactionManager) {
            PortletTransactionManager portletTransactionManager = (PortletTransactionManager)platformTransactionManager;
            SessionFactoryImplementor currentSessionFactoryImplementor = (SessionFactoryImplementor)portletTransactionManager.getPortletSessionFactory();
            if (targetSessionFactoryImplementor == currentSessionFactoryImplementor) {
                return true;
            }
            this._logFailure(currentSessionFactoryImplementor, targetSessionFactoryImplementor);
            return false;
        }
        throw new IllegalStateException("Unknown transaction manager type: " + platformTransactionManager);
    }

    private static class SessionInvocationHandler
    implements InvocationHandler {
        private final Session _session;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ReflectiveOperationException {
            return method.invoke((Object)this._session, args);
        }

        private SessionInvocationHandler(Session session) {
            this._session = session;
        }
    }
}

