/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.dao.orm.hibernate.ExceptionTranslator;
import com.liferay.portal.dao.orm.hibernate.LockModeTranslator;
import com.liferay.portal.dao.orm.hibernate.QueryImpl;
import com.liferay.portal.dao.orm.hibernate.SQLQueryImpl;
import com.liferay.portal.dao.orm.hibernate.SQLQueryTableNamesUtil;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import java.io.Serializable;
import java.sql.Connection;
import org.hibernate.LockOptions;

public class SessionImpl
implements Session {
    private final org.hibernate.Session _session;

    public SessionImpl(org.hibernate.Session session) {
        this._session = session;
    }

    @Override
    public void clear() throws ORMException {
        try {
            this._session.clear();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public Connection close() throws ORMException {
        try {
            return this._session.close();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public boolean contains(Object object) throws ORMException {
        try {
            return this._session.contains(object);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public Query createQuery(String queryString) throws ORMException {
        return this.createQuery(queryString, true);
    }

    @Override
    public Query createQuery(String queryString, boolean strictName) throws ORMException {
        try {
            queryString = SQLTransformer.transformFromJPQLToHQL(queryString);
            return new QueryImpl(this._session.createQuery(queryString), strictName);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public SQLQuery createSQLQuery(String queryString) throws ORMException {
        return this.createSQLQuery(queryString, true);
    }

    @Override
    public SQLQuery createSQLQuery(String queryString, boolean strictName) throws ORMException {
        try {
            queryString = SQLTransformer.transformFromJPQLToHQL(queryString);
            return new SQLQueryImpl(this._session.createSQLQuery(queryString), strictName);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public SQLQuery createSynchronizedSQLQuery(String queryString) throws ORMException {
        return this.createSynchronizedSQLQuery(queryString, true);
    }

    @Override
    public SQLQuery createSynchronizedSQLQuery(String queryString, boolean strictName) throws ORMException {
        try {
            queryString = SQLTransformer.transformFromJPQLToHQL(queryString);
            SQLQueryImpl sqlQuery = new SQLQueryImpl(this._session.createSQLQuery(queryString), strictName);
            String[] tableNames = SQLQueryTableNamesUtil.getTableNames(queryString);
            sqlQuery.addSynchronizedQuerySpaces(tableNames);
            return sqlQuery;
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public void delete(Object object) throws ORMException {
        try {
            this._session.delete(object);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public void evict(Object object) throws ORMException {
        try {
            this._session.evict(object);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public void flush() throws ORMException {
        try {
            this._session.flush();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public Object get(Class<?> clazz, Serializable id) throws ORMException {
        try {
            return this._session.get(clazz, id);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public Object get(Class<?> clazz, Serializable id, LockMode lockMode) throws ORMException {
        LockOptions lockOptions = new LockOptions(LockModeTranslator.translate(lockMode));
        try {
            return this._session.get(clazz, id, lockOptions);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public Object getWrappedSession() {
        return this._session;
    }

    @Override
    public boolean isDirty() throws ORMException {
        try {
            return this._session.isDirty();
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public Object load(Class<?> clazz, Serializable id) throws ORMException {
        try {
            return this._session.load(clazz, id);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public Object merge(Object object) throws ORMException {
        try {
            return this._session.merge(object);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e, this._session, object);
        }
    }

    @Override
    public Serializable save(Object object) throws ORMException {
        try {
            return this._session.save(object);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public void saveOrUpdate(Object object) throws ORMException {
        try {
            this._session.saveOrUpdate(object);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e, this._session, object);
        }
    }

    public String toString() {
        StringBundler sb = new StringBundler(3);
        sb.append("{_session=");
        sb.append(String.valueOf(this._session));
        sb.append("}");
        return sb.toString();
    }
}

