/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashSet;

public class SQLQueryTableNamesUtil {
    private static final PortalCache<String, String[]> _portalCache = PortalCacheHelperUtil.getPortalCache("SINGLE_VM_PORTAL_CACHE_MANAGER", SQLQueryTableNamesUtil.class.getName());

    public static String[] getTableNames(String sql) {
        int[] indexes;
        String[] tableNames = _portalCache.get(sql);
        if (tableNames != null) {
            return tableNames;
        }
        String lowerCaseSQL = StringUtil.toLowerCase(sql);
        HashSet<String> tableNameSet = new HashSet<String>();
        int index = 0;
        while ((index = lowerCaseSQL.indexOf(" from ", index)) != -1) {
            indexes = SQLQueryTableNamesUtil._getTableNameIndexes(lowerCaseSQL, index += 6);
            if (indexes == null) continue;
            tableNameSet.add(sql.substring(indexes[0], indexes[1]));
        }
        index = 0;
        while ((index = lowerCaseSQL.indexOf(" join ", index)) != -1) {
            indexes = SQLQueryTableNamesUtil._getTableNameIndexes(lowerCaseSQL, index += 6);
            if (indexes == null) continue;
            tableNameSet.add(sql.substring(indexes[0], indexes[1]));
        }
        tableNames = tableNameSet.toArray(new String[0]);
        _portalCache.put(sql, tableNames);
        return tableNames;
    }

    private static int[] _getTableNameIndexes(String sql, int index) {
        char c;
        int start = -1;
        int end = sql.length();
        for (int i = index; i < sql.length() && (c = sql.charAt(i)) != '('; ++i) {
            if (c == ' ' || c == ')') {
                if (start == -1) continue;
                end = i;
                break;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start == -1) {
            return null;
        }
        return new int[]{start, end};
    }
}

