/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.ConjunctionImpl;
import com.liferay.portal.dao.orm.hibernate.CriterionImpl;
import com.liferay.portal.dao.orm.hibernate.DisjunctionImpl;
import com.liferay.portal.dao.orm.hibernate.TypeTranslator;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.Type;

public class RestrictionsFactoryImpl
implements RestrictionsFactory {
    private int _databaseInMaxParameters;

    public void afterPropertiesSet() {
        DB db = DBManagerUtil.getDB();
        DBType dbType = db.getDBType();
        this._databaseInMaxParameters = GetterUtil.getInteger(PropsUtil.get("database.in.max.parameters", new Filter(dbType.getName())), Integer.MAX_VALUE);
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion allEq(Map<String, com.liferay.portal.kernel.dao.orm.Criterion> propertyNameValues) {
        return new CriterionImpl(Restrictions.allEq(propertyNameValues));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion and(com.liferay.portal.kernel.dao.orm.Criterion lhs, com.liferay.portal.kernel.dao.orm.Criterion rhs) {
        CriterionImpl lhsImpl = (CriterionImpl)lhs;
        CriterionImpl rhsImpl = (CriterionImpl)rhs;
        return new CriterionImpl((Criterion)Restrictions.and((Criterion)lhsImpl.getWrappedCriterion(), (Criterion)rhsImpl.getWrappedCriterion()));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion between(String propertyName, Object lo, Object hi) {
        return new CriterionImpl(Restrictions.between((String)propertyName, (Object)lo, (Object)hi));
    }

    @Override
    public Conjunction conjunction() {
        return new ConjunctionImpl(Restrictions.conjunction());
    }

    @Override
    public Disjunction disjunction() {
        return new DisjunctionImpl(Restrictions.disjunction());
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion eq(String propertyName, Object value) {
        return new CriterionImpl((Criterion)Restrictions.eq((String)propertyName, (Object)value));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion eqProperty(String propertyName, String otherPropertyName) {
        return new CriterionImpl((Criterion)Restrictions.eqProperty((String)propertyName, (String)otherPropertyName));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion ge(String propertyName, Object value) {
        return new CriterionImpl((Criterion)Restrictions.ge((String)propertyName, (Object)value));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion geProperty(String propertyName, String otherPropertyName) {
        return new CriterionImpl((Criterion)Restrictions.geProperty((String)propertyName, (String)otherPropertyName));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion gt(String propertyName, Object value) {
        return new CriterionImpl((Criterion)Restrictions.gt((String)propertyName, (Object)value));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion gtProperty(String propertyName, String otherPropertyName) {
        return new CriterionImpl((Criterion)Restrictions.gtProperty((String)propertyName, (String)otherPropertyName));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion ilike(String propertyName, Object value) {
        return new CriterionImpl(Restrictions.ilike((String)propertyName, (Object)value));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion in(String propertyName, Collection<?> values) {
        int size = values.size();
        if (size > this._databaseInMaxParameters) {
            Disjunction disjunction = this.disjunction();
            int end = this._databaseInMaxParameters;
            List<?> list = ListUtil.fromCollection(values);
            for (int start = 0; start < size; start += this._databaseInMaxParameters) {
                disjunction.add(new CriterionImpl(Restrictions.in((String)propertyName, ListUtil.subList(list, start, end))));
                end += this._databaseInMaxParameters;
            }
            return disjunction;
        }
        return new CriterionImpl(Restrictions.in((String)propertyName, values));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion in(String propertyName, Object[] values) {
        return this.in(propertyName, ListUtil.toList(values));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion isEmpty(String propertyName) {
        return new CriterionImpl(Restrictions.isEmpty((String)propertyName));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion isNotEmpty(String propertyName) {
        return new CriterionImpl(Restrictions.isNotEmpty((String)propertyName));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion isNotNull(String propertyName) {
        return new CriterionImpl(Restrictions.isNotNull((String)propertyName));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion isNull(String propertyName) {
        return new CriterionImpl(Restrictions.isNull((String)propertyName));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion le(String propertyName, Object value) {
        return new CriterionImpl((Criterion)Restrictions.le((String)propertyName, (Object)value));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion leProperty(String propertyName, String otherPropertyName) {
        return new CriterionImpl((Criterion)Restrictions.leProperty((String)propertyName, (String)otherPropertyName));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion like(String propertyName, Object value) {
        return new CriterionImpl((Criterion)Restrictions.like((String)propertyName, (Object)value));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion lt(String propertyName, Object value) {
        return new CriterionImpl((Criterion)Restrictions.lt((String)propertyName, (Object)value));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion ltProperty(String propertyName, String otherPropertyName) {
        return new CriterionImpl((Criterion)Restrictions.ltProperty((String)propertyName, (String)otherPropertyName));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion ne(String propertyName, Object value) {
        return new CriterionImpl((Criterion)Restrictions.ne((String)propertyName, (Object)value));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion neProperty(String propertyName, String otherPropertyName) {
        return new CriterionImpl((Criterion)Restrictions.neProperty((String)propertyName, (String)otherPropertyName));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion not(com.liferay.portal.kernel.dao.orm.Criterion expression) {
        CriterionImpl expressionImpl = (CriterionImpl)expression;
        return new CriterionImpl(Restrictions.not((Criterion)expressionImpl.getWrappedCriterion()));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion or(com.liferay.portal.kernel.dao.orm.Criterion lhs, com.liferay.portal.kernel.dao.orm.Criterion rhs) {
        CriterionImpl lhsImpl = (CriterionImpl)lhs;
        CriterionImpl rhsImpl = (CriterionImpl)rhs;
        return new CriterionImpl((Criterion)Restrictions.or((Criterion)lhsImpl.getWrappedCriterion(), (Criterion)rhsImpl.getWrappedCriterion()));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion sizeEq(String propertyName, int size) {
        return new CriterionImpl(Restrictions.sizeEq((String)propertyName, (int)size));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion sizeGe(String propertyName, int size) {
        return new CriterionImpl(Restrictions.sizeGe((String)propertyName, (int)size));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion sizeGt(String propertyName, int size) {
        return new CriterionImpl(Restrictions.sizeGe((String)propertyName, (int)size));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion sizeLe(String propertyName, int size) {
        return new CriterionImpl(Restrictions.sizeLe((String)propertyName, (int)size));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion sizeLt(String propertyName, int size) {
        return new CriterionImpl(Restrictions.sizeLt((String)propertyName, (int)size));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion sizeNe(String propertyName, int size) {
        return new CriterionImpl(Restrictions.sizeNe((String)propertyName, (int)size));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion sqlRestriction(String sql) {
        return new CriterionImpl(Restrictions.sqlRestriction((String)sql));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion sqlRestriction(String sql, Object value, com.liferay.portal.kernel.dao.orm.Type type) {
        return new CriterionImpl(Restrictions.sqlRestriction((String)sql, (Object)value, (Type)TypeTranslator.translate(type)));
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.Criterion sqlRestriction(String sql, Object[] values, com.liferay.portal.kernel.dao.orm.Type[] types) {
        Type[] hibernateTypes = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            hibernateTypes[i] = TypeTranslator.translate(types[i]);
        }
        return new CriterionImpl(Restrictions.sqlRestriction((String)sql, (Object[])values, (Type[])hibernateTypes));
    }
}

