/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.ObjectNotFoundException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;

public class ExceptionTranslator {
    public static ORMException translate(Exception e) {
        if (e instanceof org.hibernate.ObjectNotFoundException) {
            return new ObjectNotFoundException(e);
        }
        return new ORMException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ORMException translate(Exception e, Session session, Object object) {
        if (e instanceof StaleObjectStateException) {
            BaseModel baseModel = (BaseModel)object;
            Object currentObject = session.get(object.getClass(), baseModel.getPrimaryKeyObj());
            BaseModel currentObjectBaseModel = (BaseModel)currentObject;
            currentObject = currentObjectBaseModel.clone();
            object = baseModel.clone();
            JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            try {
                PermissionThreadLocal.setPermissionChecker(null);
                ORMException oRMException = new ORMException(StringBundler.concat(jsonSerializer.serialize(object), " is stale in comparison to ", jsonSerializer.serialize(currentObject)), e);
                return oRMException;
            }
            finally {
                PermissionThreadLocal.setPermissionChecker(permissionChecker);
            }
        }
        return new ORMException(e);
    }
}

