/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.DynamicQueryImpl;
import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.hibernate.criterion.DetachedCriteria;

public class DynamicQueryFactoryImpl
implements DynamicQueryFactory {
    private static final Log _log = LogFactoryUtil.getLog(DynamicQueryFactoryImpl.class);
    private final ClassLoader _portalClassLoader = DynamicQueryFactoryImpl.class.getClassLoader();

    @Override
    @Deprecated
    public DynamicQuery forClass(Class<?> clazz) {
        clazz = this.getImplClass(clazz, null);
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz));
    }

    @Override
    public DynamicQuery forClass(Class<?> clazz, ClassLoader classLoader) {
        clazz = this.getImplClass(clazz, classLoader);
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz));
    }

    @Override
    @Deprecated
    public DynamicQuery forClass(Class<?> clazz, String alias) {
        clazz = this.getImplClass(clazz, null);
        if (alias != null) {
            return new DynamicQueryImpl(DetachedCriteria.forClass(clazz, (String)alias));
        }
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz));
    }

    @Override
    public DynamicQuery forClass(Class<?> clazz, String alias, ClassLoader classLoader) {
        clazz = this.getImplClass(clazz, classLoader);
        if (alias != null) {
            return new DynamicQueryImpl(DetachedCriteria.forClass(clazz, (String)alias));
        }
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz));
    }

    protected Class<?> getImplClass(Class<?> clazz, ClassLoader classLoader) {
        ImplementationClassName implementationClassName = clazz.getAnnotation(ImplementationClassName.class);
        if (implementationClassName == null) {
            String className = clazz.getName();
            if (!className.endsWith("Impl")) {
                _log.error("Unable find model for " + clazz);
            }
            return clazz;
        }
        Class<?> implClass = clazz;
        String implClassName = implementationClassName.value();
        try {
            implClass = this.getImplClass(implClassName, classLoader);
        }
        catch (Exception e1) {
            if (classLoader != this._portalClassLoader) {
                try {
                    implClass = this.getImplClass(implClassName, this._portalClassLoader);
                }
                catch (Exception e2) {
                    _log.error("Unable find model " + implClassName, e2);
                }
            }
            _log.error("Unable find model " + implClassName, e1);
        }
        return implClass;
    }

    protected Class<?> getImplClass(String implClassName, ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.loadClass(implClassName);
    }
}

