/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.aop;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.dao.jdbc.aop.DynamicDataSourceTargetSource;
import com.liferay.portal.kernel.dao.jdbc.aop.Operation;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Stack;
import javax.sql.DataSource;
import org.springframework.aop.TargetSource;

public class DefaultDynamicDataSourceTargetSource
implements DynamicDataSourceTargetSource,
TargetSource {
    private static final Log _log = LogFactoryUtil.getLog(DefaultDynamicDataSourceTargetSource.class);
    private static final ThreadLocal<Deque<Operation>> _operations = new CentralizedThreadLocal<Deque>(DefaultDynamicDataSourceTargetSource.class + "._operations", LinkedList::new);
    private DataSource _readDataSource;
    private DataSource _writeDataSource;

    @Override
    @Deprecated
    public Stack<String> getMethodStack() {
        return new Stack<String>();
    }

    @Override
    public Operation getOperation() {
        Deque<Operation> operations = _operations.get();
        Operation operation = operations.peek();
        if (operation == null) {
            operation = Operation.WRITE;
        }
        return operation;
    }

    @Override
    public DataSource getReadDataSource() {
        return this._readDataSource;
    }

    @Override
    public Object getTarget() {
        Operation operationType = this.getOperation();
        if (operationType == Operation.READ) {
            if (_log.isTraceEnabled()) {
                _log.trace("Returning read data source");
            }
            return this._readDataSource;
        }
        if (_log.isTraceEnabled()) {
            _log.trace("Returning write data source");
        }
        return this._writeDataSource;
    }

    public Class<DataSource> getTargetClass() {
        return DataSource.class;
    }

    @Override
    public DataSource getWriteDataSource() {
        return this._writeDataSource;
    }

    public boolean isStatic() {
        return false;
    }

    @Override
    @Deprecated
    public String popMethod() {
        return null;
    }

    @Override
    public Operation popOperation() {
        Deque<Operation> operations = _operations.get();
        return operations.pop();
    }

    @Override
    @Deprecated
    public void pushMethod(String method) {
    }

    @Override
    public void pushOperation(Operation operation) {
        Deque<Operation> operations = _operations.get();
        operations.push(operation);
    }

    public void releaseTarget(Object target) throws Exception {
    }

    @Override
    @Deprecated
    public void setOperation(Operation operation) {
    }

    @Override
    public void setReadDataSource(DataSource readDataSource) {
        this._readDataSource = readDataSource;
    }

    @Override
    public void setWriteDataSource(DataSource writeDataSource) {
        this._writeDataSource = writeDataSource;
    }

    @Deprecated
    protected boolean inOperation() {
        return false;
    }
}

